/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.errorcraft.itematic.serialization.ItematicCodecs;
import net.errorcraft.itematic.util.Vec3dProvider;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionType;
import net.errorcraft.itematic.world.action.ActionTypes;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5699;

public record DisplayParticleAction(ActionContextParameter position, class_2394 particle, int count, Vec3dProvider offset, Vec3dProvider delta, double speed, boolean force) implements Action<DisplayParticleAction>
{
    public static final MapCodec<DisplayParticleAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ActionContextParameter.CODEC.fieldOf("position").forGetter(DisplayParticleAction::position), (App)class_2398.field_25125.fieldOf("particle").forGetter(DisplayParticleAction::particle), (App)class_5699.field_33441.fieldOf("count").forGetter(DisplayParticleAction::count), (App)Vec3dProvider.CODEC.optionalFieldOf("offset", (Object)Vec3dProvider.ZERO).forGetter(DisplayParticleAction::offset), (App)Vec3dProvider.CODEC.fieldOf("delta").forGetter(DisplayParticleAction::delta), (App)ItematicCodecs.NON_NEGATIVE_DOUBLE.fieldOf("speed").forGetter(DisplayParticleAction::speed), (App)Codec.BOOL.optionalFieldOf("force", (Object)false).forGetter(DisplayParticleAction::force)).apply((Applicative)instance, DisplayParticleAction::new));

    public static Builder builder(ActionContextParameter position, class_2394 particle) {
        return new Builder(position, particle);
    }

    @Override
    public ActionType<DisplayParticleAction> type() {
        return ActionTypes.DISPLAY_PARTICLE;
    }

    @Override
    public boolean execute(ActionContext context) {
        class_3218 world = context.world();
        class_243 pos = context.position(this.position).method_1019(this.offset.get(world.method_8409()));
        return this.spawnParticles(world, pos);
    }

    private boolean spawnParticles(class_3218 world, class_243 pos) {
        class_243 delta = this.delta.get(world.method_8409());
        int count = 0;
        for (class_3222 player : world.method_18456()) {
            if (!world.method_14166(player, this.particle, this.force, pos.method_10216(), pos.method_10214(), pos.method_10215(), this.count, delta.method_10216(), delta.method_10214(), delta.method_10215(), this.speed)) continue;
            ++count;
        }
        return count > 0;
    }

    public static class Builder {
        private final ActionContextParameter position;
        private final class_2394 particle;
        private int count = 0;
        private Vec3dProvider offset = Vec3dProvider.ZERO;
        private Vec3dProvider delta = Vec3dProvider.ZERO;
        private double speed = 0.0;
        private boolean force = false;

        private Builder(ActionContextParameter position, class_2394 particle) {
            this.position = position;
            this.particle = particle;
        }

        public DisplayParticleAction build() {
            return new DisplayParticleAction(this.position, this.particle, this.count, this.offset, this.delta, this.speed, this.force);
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder offset(Vec3dProvider offset) {
            this.offset = offset;
            return this;
        }

        public Builder delta(Vec3dProvider delta) {
            this.delta = delta;
            return this;
        }

        public Builder speed(double speed) {
            this.speed = speed;
            return this;
        }

        public Builder force() {
            this.force = true;
            return this;
        }
    }
}

