/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.errorcraft.itematic.util.Range;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionType;
import net.errorcraft.itematic.world.action.ActionTypes;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public record PlaySoundAction(ActionContextParameter position, class_6880<class_3414> sound, class_3419 category, Range.FloatRange volume, Range.FloatRange pitch, boolean fromEntity) implements Action<PlaySoundAction>
{
    public static final MapCodec<PlaySoundAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ActionContextParameter.CODEC.fieldOf("position").forGetter(PlaySoundAction::position), (App)class_3414.field_41699.fieldOf("sound").forGetter(PlaySoundAction::sound), (App)class_3542.method_28140(class_3419::values).fieldOf("category").forGetter(PlaySoundAction::category), (App)Range.FLOAT_CODEC.fieldOf("volume").forGetter(PlaySoundAction::volume), (App)Range.FLOAT_CODEC.fieldOf("pitch").forGetter(PlaySoundAction::pitch), (App)Codec.BOOL.optionalFieldOf("from_entity", (Object)false).forGetter(PlaySoundAction::fromEntity)).apply((Applicative)instance, PlaySoundAction::new));

    public static Builder builder(ActionContextParameter position, class_6880<class_3414> sound, class_3419 category) {
        return new Builder(position, sound, category);
    }

    public static PlaySoundAction of(ActionContextParameter position, class_6880<class_3414> sound, class_3419 category) {
        return new PlaySoundAction(position, sound, category, Range.FloatRange.of(1.0f), Range.FloatRange.of(1.0f), false);
    }

    public static PlaySoundAction of(ActionContextParameter position, class_6880<class_3414> sound, class_3419 category, float volume, float pitch) {
        return new PlaySoundAction(position, sound, category, Range.FloatRange.of(volume), Range.FloatRange.of(pitch), false);
    }

    @Override
    public ActionType<PlaySoundAction> type() {
        return ActionTypes.PLAY_SOUND;
    }

    @Override
    public boolean execute(ActionContext context) {
        class_3218 world = context.world();
        class_5819 random = world.method_8409();
        float volume = this.volume.get(random).floatValue();
        float pitch = this.pitch.get(random).floatValue();
        long seed = world.method_8409().method_43055();
        context.player(ActionContextParameter.THIS).filter(player -> this.fromEntity).ifPresentOrElse(player -> world.method_8449(null, (class_1297)player, this.sound, this.category, volume, pitch, seed), () -> {
            class_243 pos = context.position(this.position);
            world.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), this.sound, this.category, volume, pitch, seed);
        });
        return true;
    }

    public static class Builder {
        private final ActionContextParameter position;
        private final class_6880<class_3414> sound;
        private final class_3419 category;
        private Range.FloatRange volume = Range.FloatRange.of(1.0f);
        private Range.FloatRange pitch = Range.FloatRange.of(1.0f);
        private boolean fromEntity = false;

        private Builder(ActionContextParameter position, class_6880<class_3414> sound, class_3419 category) {
            this.position = position;
            this.sound = sound;
            this.category = category;
        }

        public PlaySoundAction build() {
            return new PlaySoundAction(this.position, this.sound, this.category, this.volume, this.pitch, this.fromEntity);
        }

        public Builder volume(float volume) {
            this.volume = Range.FloatRange.of(volume);
            return this;
        }

        public Builder volume(float min, float max) {
            this.volume = Range.FloatRange.of(min, max);
            return this;
        }

        public Builder pitch(float pitch) {
            this.pitch = Range.FloatRange.of(pitch);
            return this;
        }

        public Builder pitch(float min, float max) {
            this.pitch = Range.FloatRange.of(min, max);
            return this;
        }

        public Builder fromEntity() {
            this.fromEntity = true;
            return this;
        }
    }
}

