/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.planet;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.landfall.deepspace.planet.Planet;
import world.landfall.deepspace.planet.PlanetRegistry;

public final class PlanetUtils {
    private PlanetUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    @Nullable
    public static Planet getPlayerPlanet(@NotNull Player player) {
        Objects.requireNonNull(player, "Player cannot be null");
        return PlanetRegistry.getPlanetByDimension((ResourceKey<Level>)player.level().dimension());
    }

    @Nullable
    public static Planet getPlanetAtPosition(@NotNull Vec3 position) {
        Objects.requireNonNull(position, "Position cannot be null");
        List<Planet> planets = PlanetRegistry.getPlanetsAtPosition(position);
        return planets.isEmpty() ? null : planets.get(0);
    }

    @NotNull
    public static List<Planet> getAllPlanetsAtPosition(@NotNull Vec3 position) {
        Objects.requireNonNull(position, "Position cannot be null");
        return PlanetRegistry.getPlanetsAtPosition(position);
    }

    public static boolean isPositionInAnyPlanet(@NotNull Vec3 position) {
        Objects.requireNonNull(position, "Position cannot be null");
        return !PlanetRegistry.getPlanetsAtPosition(position).isEmpty();
    }

    public static double getDistanceToNearestPlanet(@NotNull Vec3 position) {
        Objects.requireNonNull(position, "Position cannot be null");
        return PlanetRegistry.getAllPlanets().stream().mapToDouble(planet -> position.distanceTo(planet.getCenter())).min().orElse(Double.MAX_VALUE);
    }

    @Nullable
    public static Planet getNearestPlanet(@NotNull Vec3 position) {
        Objects.requireNonNull(position, "Position cannot be null");
        return PlanetRegistry.getAllPlanets().stream().min((p1, p2) -> Double.compare(position.distanceTo(p1.getCenter()), position.distanceTo(p2.getCenter()))).orElse(null);
    }

    @NotNull
    public static Optional<Planet> getPlanetForDimension(@NotNull ResourceKey<Level> dimension) {
        Objects.requireNonNull(dimension, "Dimension cannot be null");
        return Optional.ofNullable(PlanetRegistry.getPlanetByDimension(dimension));
    }

    public static boolean hasPlanetForDimension(@NotNull ResourceKey<Level> dimension) {
        Objects.requireNonNull(dimension, "Dimension cannot be null");
        return PlanetRegistry.getPlanetByDimension(dimension) != null;
    }

    public static double getPlanetVolume(@NotNull Planet planet) {
        Objects.requireNonNull(planet, "Planet cannot be null");
        Vec3 min = planet.getBoundingBoxMin();
        Vec3 max = planet.getBoundingBoxMax();
        double width = max.x - min.x;
        double height = max.y - min.y;
        double depth = max.z - min.z;
        return width * height * depth;
    }

    public static boolean doPlanetsOverlap(@NotNull Planet planet1, @NotNull Planet planet2) {
        Objects.requireNonNull(planet1, "Planet1 cannot be null");
        Objects.requireNonNull(planet2, "Planet2 cannot be null");
        Vec3 min1 = planet1.getBoundingBoxMin();
        Vec3 max1 = planet1.getBoundingBoxMax();
        Vec3 min2 = planet2.getBoundingBoxMin();
        Vec3 max2 = planet2.getBoundingBoxMax();
        return !(max1.x < min2.x || max2.x < min1.x || max1.y < min2.y || max2.y < min1.y || max1.z < min2.z || max2.z < min1.z);
    }

    public static boolean isValidPlanet(@NotNull Planet planet) {
        Objects.requireNonNull(planet, "Planet cannot be null");
        try {
            if (planet.getId().trim().isEmpty() || planet.getName().trim().isEmpty()) {
                return false;
            }
            Vec3 min = planet.getBoundingBoxMin();
            Vec3 max = planet.getBoundingBoxMax();
            return min.x < max.x && min.y < max.y && min.z < max.z;
        }
        catch (Exception e) {
            return false;
        }
    }
}

