/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import world.landfall.deepspace.Deepspace;
import world.landfall.deepspace.ModOptions;
import world.landfall.deepspace.integration.IrisIntegration;
import world.landfall.deepspace.planet.Planet;
import world.landfall.deepspace.planet.PlanetRegistry;
import world.landfall.deepspace.render.SpaceRenderSystem;
import world.landfall.deepspace.render.shapes.Cube;
import world.landfall.deepspace.render.shapes.Plane;

public class PlanetDecorationsRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final HashMap<String, Ring> RING_MESHES = new HashMap();
    private static final ResourceLocation RING_SHADER = Deepspace.path("ring");
    private static final RenderStateShard.ShaderStateShard RING_RENDER_TYPE = new RenderStateShard.ShaderStateShard(() -> {
        ShaderProgram shader = VeilRenderSystem.setShader((ResourceLocation)RING_SHADER);
        return VeilRenderBridge.toShaderInstance((ShaderProgram)shader);
    });
    private static final HashMap<String, Atmosphere> ATMOSPHERE_MESHES = new HashMap();
    private static final ResourceLocation ATMOSPHERE_SHADER = Deepspace.path("atmosphere");
    private static final RenderStateShard.ShaderStateShard ATMOSPHERE_RENDER_TYPE = new RenderStateShard.ShaderStateShard(() -> {
        ShaderProgram shader = VeilRenderSystem.setShader((ResourceLocation)ATMOSPHERE_SHADER);
        return VeilRenderBridge.toShaderInstance((ShaderProgram)shader);
    });

    public static void refreshMeshes() {
        RING_MESHES.clear();
        ATMOSPHERE_MESHES.clear();
        for (Planet x : PlanetRegistry.getAllPlanets()) {
            Optional<List<Planet.PlanetDecoration>> decorations = x.getDecorations();
            if (decorations.isEmpty()) {
                return;
            }
            for (Planet.PlanetDecoration decoration : decorations.get()) {
                if (decoration.type().equals("atmosphere")) {
                    ATMOSPHERE_MESHES.put(x.getId(), new Atmosphere(new Cube(x.getBoundingBoxMin().toVector3f(), x.getBoundingBoxMax().toVector3f(), decoration.scale(), true), decoration.scale(), decoration.color()));
                    continue;
                }
                if (!decoration.type().equals("rings")) continue;
                System.out.println("Made ring!");
                RING_MESHES.put(x.getId(), new Ring(new Plane(x.getCenter().toVector3f(), decoration.scale() * (float)Math.abs(x.getBoundingBoxMin().x - x.getBoundingBoxMax().x), new Quaternionf().rotationX(1.5707964f).rotateY(0.31415927f)), decoration.scale(), decoration.color()));
            }
        }
    }

    public static void init() {
        PlanetDecorationsRenderer.refreshMeshes();
        SpaceRenderSystem.registerRenderer(PlanetDecorationsRenderer::render, VeilRenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS);
    }

    private static RenderType atmosphereRenderType() {
        RenderType.CompositeState renderType = RenderType.CompositeState.builder().setShaderState(ATMOSPHERE_RENDER_TYPE).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.CullStateShard.NO_CULL).setOutputState(RenderStateShard.TRANSLUCENT_TARGET).createCompositeState(true);
        return RenderType.create((String)"atmosphere", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)renderType);
    }

    private static RenderType ringBloomRenderType() {
        RenderType.CompositeState ringState = RenderType.CompositeState.builder().setShaderState(RING_RENDER_TYPE).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.CullStateShard.NO_CULL).setOutputState(RenderStateShard.OutputStateShard.TRANSLUCENT_TARGET).createCompositeState(true);
        RenderType.CompositeRenderType ringType = RenderType.create((String)"ring", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)ringState);
        RenderType.CompositeState bloomState = RenderType.CompositeState.builder().setShaderState(RING_RENDER_TYPE).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.CullStateShard.NO_CULL).setOutputState(VeilRenderSystem.BLOOM_SHARD).createCompositeState(true);
        RenderType.CompositeRenderType bloomType = RenderType.create((String)"ring", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)bloomState);
        return VeilRenderType.layered((RenderType[])new RenderType[]{ringType, bloomType});
    }

    private static RenderType ringRenderType() {
        RenderType.CompositeState ringState = RenderType.CompositeState.builder().setShaderState(RING_RENDER_TYPE).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setCullState(RenderStateShard.CullStateShard.NO_CULL).setOutputState(RenderStateShard.OutputStateShard.TRANSLUCENT_TARGET).createCompositeState(true);
        RenderType.CompositeRenderType ringType = RenderType.create((String)"ring", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)ringState);
        return VeilRenderType.layered((RenderType[])new RenderType[]{ringType});
    }

    public static void render(VeilRenderLevelStageEvent.Stage stage, LevelRenderer levelRenderer, MultiBufferSource.BufferSource bufferSource, MatrixStack matrixStack, Matrix4fc frustumMatrix, Matrix4fc projectionMatrix, int renderTick, DeltaTracker partialTicks, Camera camera, Frustum frustum) {
        ShaderUniform TIME_UNIFORM;
        Color color;
        Minecraft instance = Minecraft.getInstance();
        if (!instance.level.dimension().location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"deepspace", (String)"space"))) {
            return;
        }
        RenderType atmosphereRenderType = PlanetDecorationsRenderer.atmosphereRenderType();
        RenderType ringRenderType = PlanetDecorationsRenderer.ringRenderType();
        PoseStack poseStack = matrixStack.toPoseStack();
        IrisIntegration.bindPipeline();
        for (Map.Entry<String, Atmosphere> entry : ATMOSPHERE_MESHES.entrySet()) {
            BufferBuilder atmosphereBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.NEW_ENTITY);
            entry.getValue().cube.render(poseStack, (VertexConsumer)atmosphereBuilder, (Vector3fc)camera.getPosition().toVector3f().mul(-1.0f), new Quaternionf());
            color = new Color(entry.getValue().color);
            VeilRenderSystem.setShader((ResourceLocation)Deepspace.path("atmosphere"));
            TIME_UNIFORM = VeilRenderSystem.getShader().getOrCreateUniform((CharSequence)"Time");
            TIME_UNIFORM.setFloat(camera.getPartialTickTime() + (float)renderTick);
            RenderSystem.setShaderColor((float)((float)color.getRed() / 256.0f), (float)((float)color.getGreen() / 256.0f), (float)((float)color.getBlue() / 256.0f), (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Deepspace.path("textures/atmosphere.png"));
            switch (ModOptions.options().atmosphereDetail) {
                case NONE: {
                    break;
                }
                case BASIC: 
                case EXPENSIVE: {
                    atmosphereRenderType.draw(atmosphereBuilder.buildOrThrow());
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (Map.Entry<String, Record> entry : RING_MESHES.entrySet()) {
            BufferBuilder ringBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.NEW_ENTITY);
            ((Ring)entry.getValue()).mesh.render(poseStack, (VertexConsumer)ringBuilder, (Vector3fc)camera.getPosition().toVector3f().mul(-1.0f), new Quaternionf());
            color = new Color(((Ring)entry.getValue()).color);
            VeilRenderSystem.setShader((ResourceLocation)Deepspace.path("ring"));
            TIME_UNIFORM = VeilRenderSystem.getShader().getOrCreateUniform((CharSequence)"Time");
            TIME_UNIFORM.setFloat(camera.getPartialTickTime() + (float)renderTick);
            RenderSystem.setShaderColor((float)((float)color.getRed() / 256.0f), (float)((float)color.getGreen() / 256.0f), (float)((float)color.getBlue() / 256.0f), (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Deepspace.path("textures/atmosphere.png"));
            switch (ModOptions.options().atmosphereDetail) {
                case NONE: {
                    break;
                }
                case BASIC: {
                    ringRenderType.draw(ringBuilder.buildOrThrow());
                    break;
                }
                case EXPENSIVE: {
                    PlanetDecorationsRenderer.ringBloomRenderType().draw(ringBuilder.buildOrThrow());
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private record Atmosphere(Cube cube, float scale, int color) {
    }

    private record Ring(Plane mesh, float scale, int color) {
    }
}

