/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.server;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import world.landfall.deepspace.ModAttatchments;
import world.landfall.deepspace.ModDamageTypes;
import world.landfall.deepspace.ModItems;
import world.landfall.deepspace.item.JetHelmetItem;
import world.landfall.deepspace.item.JetpackItem;

public class SpacePlayerEvents {

    @EventBusSubscriber(modid="deepspace")
    public static class Tick {
        private static void jetpackTick(Player player, Level level, ItemStack jetpack, boolean noGravity) {
            boolean hasJetpack = jetpack.is((Item)ModItems.JETPACK_ITEM.get());
            if (!player.hasData(ModAttatchments.IS_FLYING_JETPACK)) {
                return;
            }
            Boolean isFlying = (Boolean)player.getData(ModAttatchments.IS_FLYING_JETPACK.get());
            JetpackItem.JetpackComponent jetpackComponent = (JetpackItem.JetpackComponent)jetpack.getComponents().get(JetpackItem.JetpackComponent.SUPPLIER.get());
            if (isFlying.booleanValue()) {
                player.getAbilities().flying = false;
                if (noGravity) {
                    player.setPose(Pose.FALL_FLYING);
                }
                if (player.isShiftKeyDown() || player.onGround()) {
                    player.setData(ModAttatchments.IS_FLYING_JETPACK, (Object)false);
                    player.setData(ModAttatchments.IS_ROCKETING_FORWARD, (Object)false);
                    player.setData(ModAttatchments.JETPACK_VELOCITY, (Object)new Vector3f());
                    return;
                }
                if (jetpackComponent != null && !jetpackComponent.canFly()) {
                    return;
                }
                Vec3 lookAngle = player.getLookAngle();
                Vec3 deltas = player.getDeltaMovement();
                Vector3f storedVelocity = (Vector3f)player.getData(ModAttatchments.JETPACK_VELOCITY);
                Boolean keyPressed = (Boolean)player.getData(ModAttatchments.IS_ROCKETING_FORWARD);
                Vector3f rocketVelocity = lookAngle.toVector3f().mul(0.04f);
                if (!noGravity) {
                    rocketVelocity.add((Vector3fc)new Vector3f(0.0f, 0.04f, 0.0f)).mul(0.1f, 2.0f, 0.1f);
                }
                Vector3f newVelocity = new Vector3f((Vector3fc)storedVelocity);
                if (keyPressed.booleanValue()) {
                    newVelocity.add((Vector3fc)rocketVelocity);
                    RandomSource random = level.getRandom();
                    for (int i = 0; i < 4; ++i) {
                        Vector3f offset = new Vector3f(random.nextFloat() * 2.0f - 1.0f, random.nextFloat() * 2.0f - 1.0f, random.nextFloat() * 2.0f - 1.0f).mul(0.4f);
                        Vector3f oppositeForce = new Vector3f((Vector3fc)newVelocity).normalize();
                        offset.sub((Vector3fc)oppositeForce.mul(2.0f));
                        level.addParticle((ParticleOptions)ParticleTypes.FLAME, player.getX() + (double)offset.x, player.getY() + (double)offset.y, player.getZ() + (double)offset.z, (double)oppositeForce.x * -0.1, (double)oppositeForce.y * -0.1, (double)oppositeForce.z * -0.1);
                    }
                }
                if (!keyPressed.booleanValue()) {
                    newVelocity.add((Vector3fc)new Vector3f(0.0f, -0.01f, 0.0f));
                    newVelocity.mul(0.99f);
                }
                if (newVelocity.length() > 8.0f) {
                    newVelocity.mul(0.9f);
                }
                player.setData(ModAttatchments.JETPACK_VELOCITY, (Object)newVelocity);
                player.setDeltaMovement(new Vec3((double)newVelocity.x, (double)newVelocity.y, (double)newVelocity.z));
                float rot = Tick.angle(newVelocity.x, newVelocity.z);
                rot = Float.isNaN(rot) ? 0.0f : rot;
                player.setYBodyRot(rot);
                float headRot = player.getYHeadRot() - rot;
                float headAngle = (Math.abs(headRot) * (float)(headRot < 0.0f ? -1 : 1) + (float)(headRot < 0.0f ? 540 : 180)) % 360.0f - 180.0f;
                if (Float.isNaN(headAngle)) {
                    headAngle = -rot;
                }
                int maxHeadTurn = 70;
                player.setYHeadRot(Math.clamp(headAngle, (float)(-maxHeadTurn), (float)maxHeadTurn) * (1.0f - Math.abs((float)player.getLookAngle().y)) + rot);
            } else {
                Vec3 deltas = player.getDeltaMovement();
                player.setData(ModAttatchments.JETPACK_VELOCITY, (Object)deltas.toVector3f());
            }
        }

        private static void jetHelmetTick(Player player, Level level, ItemStack jetHelmet, boolean noGravity) {
            boolean hasJetHelmet = jetHelmet.is((Item)ModItems.JET_HELMET_ITEM.get());
            JetHelmetItem.JetHelmetComponent component = (JetHelmetItem.JetHelmetComponent)jetHelmet.getComponents().get(JetHelmetItem.JetHelmetComponent.SUPPLIER.get());
            int tick = player.tickCount;
            if (component != null && noGravity && !player.isCreative()) {
                player.setAirSupply(component.playerOxygen());
                if (component.playerOxygen() < 1 && tick % 10 == 0) {
                    player.hurt(ModDamageTypes.noAirDamage((Entity)player), 1.0f);
                }
            } else if (!hasJetHelmet && noGravity) {
                player.setAirSupply(0);
                if (tick % 10 == 0) {
                    player.hurt(ModDamageTypes.noAirDamage((Entity)player), 2.0f);
                }
            }
        }

        @SubscribeEvent
        public static void playerTick(PlayerTickEvent.Post event) {
            Player player = event.getEntity();
            ResourceLocation dimension = player.level().dimension().location();
            boolean noGravity = dimension.equals((Object)ResourceLocation.parse((String)"deepspace:space"));
            player.setNoGravity(noGravity);
            if (noGravity && !player.getAbilities().flying) {
                player.setDeltaMovement(player.getDeltaMovement().add(new Vec3(0.0, (double)-0.01f, 0.0)));
            }
            ItemStack jetpackSlot = player.getItemBySlot(EquipmentSlot.CHEST);
            ItemStack jetHelmetSlot = player.getItemBySlot(EquipmentSlot.HEAD);
            Tick.jetpackTick(player, player.level(), jetpackSlot, noGravity);
            Tick.jetHelmetTick(player, player.level(), jetHelmetSlot, noGravity);
        }

        private static float angle(float x, float y) {
            float rot = (float)Math.atan(y / x) / ((float)Math.PI * 2) * 360.0f;
            if (x < 0.0f) {
                rot += 180.0f;
            } else if (y < 0.0f) {
                rot += 360.0f;
            }
            return rot - 90.0f;
        }

        @SubscribeEvent
        public static void fallEvent(LivingFallEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                event.setDistance(player.level().dimension().location().equals((Object)ResourceLocation.parse((String)"deepspace:space")) ? 0.0f : event.getDistance());
            }
        }

        @SubscribeEvent
        public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            player.setData(ModAttatchments.IS_FLYING_JETPACK, (Object)false);
            player.setData(ModAttatchments.IS_ROCKETING_FORWARD, (Object)false);
        }
    }
}

