/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.integration;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import org.slf4j.Logger;

public class IrisIntegration {
    private static Logger logger = LogUtils.getLogger();
    private static Class IRIS_INSTANCE_CLASS;
    private static Object IRIS_INSTANCE;

    public static boolean isShaderPackEnabled() {
        try {
            return (Boolean)IRIS_INSTANCE_CLASS.getDeclaredMethod("isShaderPackInUse", new Class[0]).invoke(IRIS_INSTANCE, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            logger.error("", (Throwable)e);
            return false;
        }
    }

    public static void bindPipeline() {
        try {
            Class<?> iris = Class.forName("net.irisshaders.iris.Iris");
            Object pipelineManager = iris.getDeclaredMethod("getPipelineManager", new Class[0]).invoke(null, new Object[0]);
            Optional pipeline = (Optional)Class.forName("net.irisshaders.iris.pipeline.PipelineManager").getDeclaredMethod("getPipeline", new Class[0]).invoke(pipelineManager, new Object[0]);
            pipeline.map(i -> {
                try {
                    if (Class.forName("net.irisshaders.iris.pipeline.IrisRenderingPipeline").isInstance(i)) {
                        return i;
                    }
                    return null;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }).ifPresent(i -> {
                try {
                    Class.forName("net.irisshaders.iris.pipeline.IrisRenderingPipeline").getDeclaredMethod("bindDefault", new Class[0]).invoke(i, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    logger.error("", (Throwable)e);
                }
            });
        }
        catch (ReflectiveOperationException e) {
            logger.error("Error in bindPipeline()", (Throwable)e);
        }
    }

    static {
        try {
            IRIS_INSTANCE_CLASS = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            IRIS_INSTANCE = IRIS_INSTANCE_CLASS.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            logger.error("", (Throwable)e);
        }
    }
}

