/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.network;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import world.landfall.deepspace.Deepspace;
import world.landfall.deepspace.planet.Planet;
import world.landfall.deepspace.planet.PlanetRegistry;
import world.landfall.deepspace.planet.Sun;
import world.landfall.deepspace.render.PlanetDecorationsRenderer;
import world.landfall.deepspace.render.PlanetRenderer;
import world.landfall.deepspace.render.SunRenderer;

public record PlanetSyncPacket(List<Planet> planets, Sun sun) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<PlanetSyncPacket> TYPE = new CustomPacketPayload.Type(Deepspace.path("planet_sync"));
    public static final StreamCodec<FriendlyByteBuf, PlanetSyncPacket> STREAM_CODEC = StreamCodec.ofMember(PlanetSyncPacket::encode, PlanetSyncPacket::decode);

    public PlanetSyncPacket(@NotNull Collection<Planet> planets, Sun sun) {
        this((List<Planet>)new ArrayList<Planet>(Objects.requireNonNull(planets, "Planets cannot be null")), Objects.requireNonNull(sun, "Sun cannot be null"));
    }

    @NotNull
    public static PlanetSyncPacket createSyncPacket() {
        return new PlanetSyncPacket(PlanetRegistry.getAllPlanets(), PlanetRegistry.getSun());
    }

    public static void encode(@NotNull PlanetSyncPacket packet, @NotNull FriendlyByteBuf buffer) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        buffer.writeInt(packet.planets.size());
        for (Planet planet : packet.planets) {
            planet.toNetwork(buffer);
        }
        packet.sun.toNetwork(buffer);
    }

    @NotNull
    public static PlanetSyncPacket decode(@NotNull FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        int planetCount = buffer.readInt();
        ArrayList<Planet> planets = new ArrayList<Planet>(planetCount);
        for (int i = 0; i < planetCount; ++i) {
            planets.add(Planet.fromNetwork(buffer));
        }
        Sun sun = Sun.fromNetwork(buffer);
        return new PlanetSyncPacket((List<Planet>)planets, sun);
    }

    public static void handle(@NotNull PlanetSyncPacket packet, @NotNull IPayloadContext context) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        Objects.requireNonNull(context, "Context cannot be null");
        context.enqueueWork(() -> {
            PlanetRegistry.clear();
            for (Planet planet : packet.planets) {
                PlanetRegistry.registerPlanet(planet);
            }
            LOGGER.info("Synchronized {} planets from server", (Object)packet.planets.size());
            PlanetRegistry.setSun(packet.sun);
            LOGGER.info("Synchronized sun from server");
            PlanetRenderer.refreshMeshes();
            PlanetDecorationsRenderer.refreshMeshes();
            SunRenderer.refreshMeshes();
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

