/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.render;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.platform.VeilEventPlatform;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.landfall.deepspace.render.PlanetDecorationsRenderer;
import world.landfall.deepspace.render.PlanetRenderer;
import world.landfall.deepspace.render.SpaceSkyRenderer;
import world.landfall.deepspace.render.SunRenderer;

public class SpaceRenderSystem {
    private static final Collection<Renderer> renderers = new LinkedList<Renderer>();

    public static void init() {
        SpaceSkyRenderer.init();
        PlanetRenderer.init();
        SunRenderer.init();
        PlanetDecorationsRenderer.init();
        VeilEventPlatform.INSTANCE.preVeilPostProcessing((location, pipeline, ctx) -> {
            pipeline.getOrCreateUniform((CharSequence)"Time").setFloat(0.0f);
            pipeline.getOrCreateUniform((CharSequence)"SunLocation").setVector(new float[]{0.0f, 0.0f, 0.0f});
        });
        VeilEventPlatform.INSTANCE.onVeilRenderLevelStage((stage, levelRenderer, bufferSource, matrixStack, frustumMatrix, projectionMatrix, renderTick, partialTicks, camera, frustum) -> {
            if (stage.equals((Object)VeilRenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS)) {
                PostProcessingManager postProcessingManager = VeilRenderSystem.renderer().getPostProcessingManager();
            }
            for (Renderer x : renderers) {
                if (!stage.equals((Object)x.stage) && x.stage != null) continue;
                x.e.onRenderLevelStage(stage, levelRenderer, bufferSource, matrixStack, frustumMatrix, projectionMatrix, renderTick, partialTicks, camera, frustum);
            }
        });
    }

    public static void registerRenderer(@NotNull VeilRenderLevelStageEvent e, @Nullable VeilRenderLevelStageEvent.Stage stage) {
        renderers.add(new Renderer(Objects.requireNonNull(e), stage));
    }

    private record Renderer(VeilRenderLevelStageEvent e, VeilRenderLevelStageEvent.Stage stage) {
    }
}

