/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import world.landfall.deepspace.Deepspace;
import world.landfall.deepspace.integration.IrisIntegration;
import world.landfall.deepspace.render.SpaceRenderSystem;
import world.landfall.deepspace.render.shapes.Sphere;

public class SpaceSkyRenderer {
    private static final Sphere skySphere = new Sphere(30.0, 32, 64);
    private static final ResourceLocation SPACE_SKY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"deepspace", (String)"textures/space_sky.png");
    private static final ResourceLocation SPACE_SKY_SHADER = Deepspace.path("space_sky");
    private static final RenderStateShard.ShaderStateShard SPACE_SKY_RENDER_TYPE = new RenderStateShard.ShaderStateShard(() -> {
        ShaderProgram shader = VeilRenderSystem.setShader((ResourceLocation)SPACE_SKY_SHADER);
        return VeilRenderBridge.toShaderInstance((ShaderProgram)shader);
    });

    private static RenderType skyShaderType(ResourceLocation texture) {
        RenderType.CompositeState renderType = RenderType.CompositeState.builder().setShaderState(SPACE_SKY_RENDER_TYPE).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).createCompositeState(true);
        return RenderType.create((String)"space_sky", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)renderType);
    }

    public static void render(VeilRenderLevelStageEvent.Stage stage, LevelRenderer levelRenderer, MultiBufferSource.BufferSource bufferSource, MatrixStack matrixStack, Matrix4fc frustumMatrix, Matrix4fc projectionMatrix, int renderTick, DeltaTracker partialTicks, Camera camera, Frustum frustum) {
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        Minecraft instance = Minecraft.getInstance();
        ResourceLocation dim = instance.level.dimension().location();
        if (dim.equals((Object)ResourceLocation.parse((String)"minecraft:overworld"))) {
            return;
        }
        boolean in_sarrion = dim.equals((Object)ResourceLocation.parse((String)"deepspace:sarrion"));
        RenderType renderType = SpaceSkyRenderer.skyShaderType(SPACE_SKY_TEXTURE);
        PoseStack poseStack = matrixStack.toPoseStack();
        poseStack.pushPose();
        skySphere.render(poseStack, (VertexConsumer)builder, (Vector3fc)new Vector3f(), new Quaternionf());
        IrisIntegration.bindPipeline();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        if (in_sarrion) {
            RenderSystem.setShaderColor((float)0.4f, (float)0.1f, (float)0.1f, (float)1.0f);
        }
        renderType.draw(builder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferSource.endBatch(renderType);
        poseStack.popPose();
    }

    public static void init() {
        SpaceRenderSystem.registerRenderer(SpaceSkyRenderer::render, VeilRenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS);
    }
}

