/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import world.landfall.deepspace.Deepspace;
import world.landfall.deepspace.ModOptions;
import world.landfall.deepspace.integration.IrisIntegration;
import world.landfall.deepspace.planet.PlanetRegistry;
import world.landfall.deepspace.planet.Sun;
import world.landfall.deepspace.render.SpaceRenderSystem;
import world.landfall.deepspace.render.shapes.Cube;

public class SunRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Cube MESH;
    private static final ResourceLocation TEXTURE;
    private static final ResourceLocation SUN_SHADER;
    private static final RenderStateShard.ShaderStateShard SUN_RENDER_TYPE;

    private static RenderType sunRenderType() {
        RenderType.CompositeState sunState = RenderType.CompositeState.builder().setShaderState(SUN_RENDER_TYPE).setOutputState(RenderStateShard.OutputStateShard.MAIN_TARGET).createCompositeState(true);
        RenderType.CompositeRenderType sunRenderType = RenderType.create((String)"sun", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)sunState);
        return VeilRenderType.layered((RenderType[])new RenderType[]{sunRenderType});
    }

    private static RenderType sunBloomRenderType() {
        RenderType.CompositeState sunState = RenderType.CompositeState.builder().setShaderState(SUN_RENDER_TYPE).setOutputState(RenderStateShard.OutputStateShard.MAIN_TARGET).createCompositeState(true);
        RenderType.CompositeRenderType sunRenderType = RenderType.create((String)"sun", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)sunState);
        RenderType.CompositeState bloomState = RenderType.CompositeState.builder().setShaderState(SUN_RENDER_TYPE).setOutputState(VeilRenderSystem.BLOOM_SHARD).createCompositeState(true);
        RenderType.CompositeRenderType bloomRenderType = RenderType.create((String)"sun", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)bloomState);
        return VeilRenderType.layered((RenderType[])new RenderType[]{sunRenderType, bloomRenderType});
    }

    public static void refreshMeshes() {
        Sun sun = PlanetRegistry.getSun();
        if (sun == null) {
            return;
        }
        MESH = new Cube(sun.getBoundingBoxMin().toVector3f(), sun.getBoundingBoxMax().toVector3f(), 1.0f, false);
    }

    public static void render(VeilRenderLevelStageEvent.Stage stage, LevelRenderer levelRenderer, MultiBufferSource.BufferSource bufferSource, MatrixStack matrixStack, Matrix4fc frustumMatrix, Matrix4fc projectionMatrix, int renderTick, DeltaTracker partialTicks, Camera camera, Frustum frustum) {
        Minecraft instance = Minecraft.getInstance();
        ResourceLocation dim = instance.level.dimension().location();
        if (dim.equals((Object)ResourceLocation.parse((String)"minecraft:overworld"))) {
            return;
        }
        boolean in_sarrion = dim.equals((Object)ResourceLocation.parse((String)"deepspace:sarrion"));
        RenderType sunRenderType = SunRenderer.sunRenderType();
        PoseStack poseStack = matrixStack.toPoseStack();
        BufferBuilder sunBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.NEW_ENTITY);
        float time = instance.level.getTimeOfDay(partialTicks.getGameTimeDeltaTicks());
        float x = (float)Math.cos(time * 2.0f * 3.14159f);
        float y = (float)Math.sin(time * 2.0f * 3.14159f);
        Vector3f pos = in_sarrion ? new Vector3f(-1500.0f * y, 1500.0f * x, 300.0f * y).sub((Vector3fc)SunRenderer.MESH.center).sub((Vector3fc)new Vector3f(SunRenderer.MESH.radius)) : camera.getPosition().toVector3f().mul(-1.0f);
        MESH.render(poseStack, (VertexConsumer)sunBuilder, (Vector3fc)pos, new Quaternionf());
        VeilRenderSystem.setShader((ResourceLocation)Deepspace.path("sun"));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        float overloadedColor = 2.0f;
        if (IrisIntegration.isShaderPackEnabled()) {
            RenderSystem.setShaderColor((float)overloadedColor, (float)overloadedColor, (float)overloadedColor, (float)3.0f);
        }
        IrisIntegration.bindPipeline();
        switch (ModOptions.options().atmosphereDetail) {
            case NONE: 
            case BASIC: {
                sunRenderType.draw(sunBuilder.buildOrThrow());
                break;
            }
            case EXPENSIVE: {
                SunRenderer.sunBloomRenderType().draw(sunBuilder.buildOrThrow());
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void init() {
        SunRenderer.refreshMeshes();
        SpaceRenderSystem.registerRenderer(SunRenderer::render, VeilRenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS);
    }

    static {
        TEXTURE = Deepspace.path("textures/sun.png");
        SUN_SHADER = Deepspace.path("sun");
        SUN_RENDER_TYPE = new RenderStateShard.ShaderStateShard(() -> {
            ShaderProgram shader = VeilRenderSystem.setShader((ResourceLocation)SUN_SHADER);
            return VeilRenderBridge.toShaderInstance((ShaderProgram)shader);
        });
    }
}

