/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.planet;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Planet {
    public static final Codec<Planet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(Planet::getId), (App)Codec.STRING.fieldOf("name").forGetter(Planet::getName), (App)ResourceLocation.CODEC.fieldOf("dimension").forGetter(planet -> planet.getDimension().location()), (App)Vec3.CODEC.fieldOf("boundingBoxMin").forGetter(Planet::getBoundingBoxMin), (App)Vec3.CODEC.fieldOf("boundingBoxMax").forGetter(Planet::getBoundingBoxMax), (App)Codec.list(PlanetDecoration.CODEC).optionalFieldOf("decorations").forGetter(Planet::getDecorations), (App)Codec.STRING.optionalFieldOf("description", (Object)"").forGetter(Planet::getDescription)).apply((Applicative)instance, (id, name, dimensionLocation, min, max, decorations, description) -> new Planet((String)id, (String)name, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation), (Vec3)min, (Vec3)max, decorations.orElseGet(List::of), (String)description)));
    private final String id;
    private final String name;
    private final ResourceKey<Level> dimension;
    private final Vec3 boundingBoxMin;
    private final Vec3 boundingBoxMax;
    private final String description;
    private final Collection<PlanetDecoration> decorations;

    public Planet(@NotNull String id, @NotNull String name, @NotNull ResourceKey<Level> dimension, @NotNull Vec3 boundingBoxMin, @NotNull Vec3 boundingBoxMax, @Nullable Collection<PlanetDecoration> decorations, @Nullable String description) {
        this.id = Objects.requireNonNull(id, "Planet ID cannot be null");
        this.name = Objects.requireNonNull(name, "Planet name cannot be null");
        this.dimension = Objects.requireNonNull(dimension, "Planet dimension cannot be null");
        this.boundingBoxMin = Objects.requireNonNull(boundingBoxMin, "Bounding box minimum cannot be null");
        this.boundingBoxMax = Objects.requireNonNull(boundingBoxMax, "Bounding box maximum cannot be null");
        this.description = description != null ? description : "";
        Collection<PlanetDecoration> collection = this.decorations = decorations != null ? decorations : List.of();
        if (boundingBoxMin.x > boundingBoxMax.x || boundingBoxMin.y > boundingBoxMax.y || boundingBoxMin.z > boundingBoxMax.z) {
            throw new IllegalArgumentException("Invalid bounding box: minimum coordinates must be less than maximum coordinates");
        }
    }

    public Planet(@NotNull String id, @NotNull String name, @NotNull ResourceKey<Level> dimension, @NotNull Vec3 boundingBoxMin, @NotNull Vec3 boundingBoxMax, @NotNull Collection<PlanetDecoration> decorations) {
        this(id, name, dimension, boundingBoxMin, boundingBoxMax, decorations, "");
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @NotNull
    public Vec3 getBoundingBoxMin() {
        return this.boundingBoxMin;
    }

    @NotNull
    public Vec3 getBoundingBoxMax() {
        return this.boundingBoxMax;
    }

    @NotNull
    public Optional<List<PlanetDecoration>> getDecorations() {
        return Optional.of(this.decorations.stream().toList());
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public boolean isWithinBounds(@NotNull Vec3 position) {
        Objects.requireNonNull(position, "Position cannot be null");
        return position.x >= this.boundingBoxMin.x && position.x <= this.boundingBoxMax.x && position.y >= this.boundingBoxMin.y && position.y <= this.boundingBoxMax.y && position.z >= this.boundingBoxMin.z && position.z <= this.boundingBoxMax.z;
    }

    public boolean isPlayerTouching(@NotNull Player player) {
        Objects.requireNonNull(player);
        Vec3 position = player.position();
        return position.x >= this.boundingBoxMin.x - 0.5 && position.x <= this.boundingBoxMax.x + 0.5 && position.y >= this.boundingBoxMin.y - 2.0 && position.y <= this.boundingBoxMax.y && position.z >= this.boundingBoxMin.z - 0.5 && position.z <= this.boundingBoxMax.z + 0.5;
    }

    @NotNull
    public Vec3 getCenter() {
        return new Vec3((this.boundingBoxMin.x + this.boundingBoxMax.x) / 2.0, (this.boundingBoxMin.y + this.boundingBoxMax.y) / 2.0, (this.boundingBoxMin.z + this.boundingBoxMax.z) / 2.0);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        buffer.writeUtf(this.id);
        buffer.writeUtf(this.name);
        buffer.writeResourceLocation(this.dimension.location());
        buffer.writeDouble(this.boundingBoxMin.x);
        buffer.writeDouble(this.boundingBoxMin.y);
        buffer.writeDouble(this.boundingBoxMin.z);
        buffer.writeDouble(this.boundingBoxMax.x);
        buffer.writeDouble(this.boundingBoxMax.y);
        buffer.writeDouble(this.boundingBoxMax.z);
        buffer.writeCollection(this.decorations, PlanetDecoration::toNetwork);
        buffer.writeUtf(this.description);
    }

    @NotNull
    public static Planet fromNetwork(@NotNull FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        String id = buffer.readUtf();
        String name = buffer.readUtf();
        ResourceLocation dimensionLocation = buffer.readResourceLocation();
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
        Vec3 boundingBoxMin = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        Vec3 boundingBoxMax = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        List decorations = buffer.readList(PlanetDecoration::fromNetwork);
        String description = buffer.readUtf();
        return new Planet(id, name, (ResourceKey<Level>)dimension, boundingBoxMin, boundingBoxMax, decorations, description);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Planet planet = (Planet)obj;
        return Objects.equals(this.id, planet.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "Planet{id='" + this.id + "', name='" + this.name + "', dimension=" + String.valueOf(this.dimension) + ", boundingBoxMin=" + String.valueOf(this.boundingBoxMin) + ", boundingBoxMax=" + String.valueOf(this.boundingBoxMax) + ", description='" + this.description + "'}";
    }

    public record PlanetDecoration(@NotNull String type, float scale, int color) {
        public static final String ATMOSPHERE = "atmosphere";
        public static final String RINGS = "rings";
        public static final String ASTEROIDS = "asteroids";
        public static final Codec<PlanetDecoration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(decoration -> decoration.type), (App)Codec.FLOAT.fieldOf("scale").forGetter(PlanetDecoration::scale), (App)Codec.INT.fieldOf("color").forGetter(PlanetDecoration::color)).apply((Applicative)instance, (type, scale, color) -> {
            PlanetDecoration decor = new PlanetDecoration((String)type, scale.floatValue(), (int)color);
            System.out.println("TESTING - " + decor.type);
            return decor;
        }));

        public static void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull PlanetDecoration decoration) {
            System.out.println(decoration.type + " " + decoration.scale + " " + decoration.color);
            buffer.writeUtf(decoration.type);
            buffer.writeFloat(decoration.scale);
            buffer.writeInt(decoration.color);
        }

        public static PlanetDecoration fromNetwork(@NotNull FriendlyByteBuf buffer) {
            System.out.println("TESTING");
            return new PlanetDecoration(buffer.readUtf(), buffer.readFloat(), buffer.readInt());
        }
    }
}

