/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.planet;

import com.mojang.logging.LogUtils;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;
import world.landfall.deepspace.planet.Planet;
import world.landfall.deepspace.planet.PlanetUtils;

@EventBusSubscriber(modid="deepspace")
public class PlanetTeleportHandler {
    private static final Vec3[] directions = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, -1.0, 0.0), new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 0.0, -1.0), new Vec3(1.0, 1.0, 1.0), new Vec3(-1.0, 1.0, 1.0), new Vec3(1.0, -1.0, 1.0), new Vec3(-1.0, -1.0, 1.0), new Vec3(1.0, 1.0, -1.0), new Vec3(-1.0, 1.0, -1.0), new Vec3(1.0, -1.0, -1.0), new Vec3(-1.0, -1.0, -1.0)};
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RandomSource random = RandomSource.create();
    private static final float DISTANCE_FROM_PLANET_TO_TELEPORT_FROM = 1.5f;
    private static final int SPACE_DISTANCE_FROM_CEILING = 10;

    @SubscribeEvent
    public static void serverPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level.getServer() == null) {
            return;
        }
        Planet planet = PlanetUtils.getPlayerPlanet(player);
        Planet closestPlanet = PlanetUtils.getNearestPlanet(player.position());
        ResourceLocation dimension = level.dimension().location();
        int height = level.getHeight();
        if (player.position().y > (double)(height + 10) && planet != null) {
            LOGGER.info("Teleporting player {} to planet {}", (Object)player.getDisplayName().getString(), (Object)planet.getName());
            Vec3 pos = PlanetTeleportHandler.getSafePlanetExitLocation(planet);
            player.teleportTo(player.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"deepspace:space"))), pos.x, pos.y, pos.z, Set.of(), 0.0f, 0.0f);
        } else if (closestPlanet != null && dimension.equals((Object)ResourceLocation.parse((String)"deepspace:space")) && closestPlanet.isPlayerTouching(player)) {
            ServerLevel newLevel = player.getServer().getLevel(closestPlanet.getDimension());
            Vec3 playerPos = player.position();
            Vec3 planetPos = closestPlanet.getCenter();
            Vec3 relativePos = planetPos.subtract(playerPos);
            float planetRadius = (float)Math.abs(closestPlanet.getBoundingBoxMin().x - planetPos.x);
            float pRadius = (float)Math.sqrt(relativePos.x * relativePos.x + relativePos.y * relativePos.y + relativePos.z * relativePos.z);
            float pAzimuth = (float)Math.atan2(relativePos.z, relativePos.x);
            float pTheta = (float)Math.acos(relativePos.y / (double)pRadius);
            float levelRadius = (float)level.getWorldBorder().getDistanceToBorder(0.0, 0.0);
            float[] finalPos = (double)pTheta > 2.356194490192345 ? new float[]{(float)relativePos.x / planetRadius, -((float)relativePos.z) / planetRadius} : ((double)pTheta < 0.7853981633974483 ? new float[]{-((float)relativePos.x) / planetRadius, (float)relativePos.z / planetRadius} : ((double)pAzimuth - 0.7853981633974483 < -Math.PI || (double)pAzimuth - 0.7853981633974483 > 1.5707963267948966 ? new float[]{(float)relativePos.z / planetRadius, -((float)relativePos.y) / planetRadius} : ((double)pAzimuth - 0.7853981633974483 < -1.5707963267948966 ? new float[]{-((float)relativePos.x) / planetRadius, -((float)relativePos.y) / planetRadius} : ((double)pAzimuth - 0.7853981633974483 < 0.0 ? new float[]{-((float)relativePos.z) / planetRadius, -((float)relativePos.y) / planetRadius} : new float[]{(float)relativePos.x / planetRadius, -((float)relativePos.y) / planetRadius}))));
            player.teleportTo(newLevel, (double)(finalPos[0] * levelRadius), (double)newLevel.getHeight(), (double)(finalPos[1] * levelRadius), Set.of(), 0.0f, 0.0f);
            player.forceAddEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 2400, 1, false, true), null);
        }
    }

    private static Vec3 getSafePlanetExitLocation(Planet planet) {
        Vec3 center = planet.getCenter();
        Vec3 size = planet.getBoundingBoxMax().subtract(planet.getBoundingBoxMin());
        double maxSize = Math.max(Math.max(size.x, size.y), size.z) / 2.0;
        Vec3 pos = directions[random.nextIntBetweenInclusive(0, directions.length - 1)];
        return center.add(pos.scale(maxSize).scale(1.5));
    }
}

