/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.render.shapes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import foundry.veil.api.client.color.Color;
import java.util.LinkedList;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import world.landfall.deepspace.render.shapes.DeepSpaceRenderable;
import world.landfall.deepspace.render.shapes.Triangle;

public class Cube
implements DeepSpaceRenderable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private LinkedList<Triangle> TRIANGLES = new LinkedList();
    private final Vector3f center;
    private final boolean weirdNormals;

    public Cube(Vector3f _corner1, Vector3f _corner2, float scale, boolean weirdNormals) {
        Vector3f center;
        this.weirdNormals = weirdNormals;
        Vector3f corner1 = new Vector3f(_corner1.x, _corner1.y, _corner1.z);
        Vector3f corner2 = new Vector3f(_corner2.x, _corner2.y, _corner2.z);
        this.center = center = new Vector3f((Vector3fc)corner1).add((Vector3fc)corner2).div(2.0f);
        Vector3f diff = new Vector3f((Vector3fc)corner1).sub((Vector3fc)corner2).div(2.0f);
        Quaternionf[] rotations = new Quaternionf[]{new Quaternionf(), new Quaternionf().rotateLocalY(1.5707964f), new Quaternionf().rotateLocalY((float)Math.PI), new Quaternionf().rotateLocalY(4.712389f), new Quaternionf().rotateLocalX(1.5707964f), new Quaternionf().rotateLocalX(-1.5707964f)};
        diff.mul(scale);
        for (Quaternionf x : rotations) {
            Vector3f[] vertexes = new Vector3f[]{new Vector3f(diff.x, diff.y, diff.z), new Vector3f(diff.x, -diff.y, diff.z), new Vector3f(-diff.x, diff.y, diff.z), new Vector3f(diff.x, -diff.y, diff.z), new Vector3f(-diff.x, diff.y, diff.z), new Vector3f(-diff.x, -diff.y, diff.z)};
            Triangle triangle1 = new Triangle(new Vector3f[]{vertexes[0].rotate((Quaternionfc)x).add((Vector3fc)center), vertexes[1].rotate((Quaternionfc)x).add((Vector3fc)center), vertexes[2].rotate((Quaternionfc)x).add((Vector3fc)center)}, new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 0.0f)}, new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)x), new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)x), new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)x)});
            Triangle triangle2 = new Triangle(new Vector3f[]{vertexes[4].rotate((Quaternionfc)x).add((Vector3fc)center), vertexes[3].rotate((Quaternionfc)x).add((Vector3fc)center), vertexes[5].rotate((Quaternionfc)x).add((Vector3fc)center)}, new Vector2f[]{new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f)}, new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)x), new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)x), new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)x)});
            this.TRIANGLES.add(triangle1);
            this.TRIANGLES.add(triangle2);
        }
    }

    @Override
    public void render(PoseStack stack, VertexConsumer consumer, Vector3fc dimensions, Quaternionf rotation) {
        for (Triangle triangle : this.TRIANGLES) {
            for (int i = 0; i < 3; ++i) {
                Vector3f oldVertex = triangle.vertexes[i];
                Vector3f vertex = new Vector3f(oldVertex.x, oldVertex.y, oldVertex.z);
                vertex.rotate((Quaternionfc)rotation);
                Vector2f UV = triangle.UV[i];
                Vector3f normal = this.weirdNormals ? new Vector3f((Vector3fc)vertex).sub((Vector3fc)this.center).normalize() : triangle.normals[i];
                consumer.addVertex(vertex.x + dimensions.x(), vertex.y + dimensions.y(), vertex.z + dimensions.z(), Color.WHITE.argb(), UV.x, UV.y, 0, 255, normal.x, normal.y, normal.z);
            }
        }
    }
}

