/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import world.landfall.deepspace.Config;
import world.landfall.deepspace.ModArmorMaterials;
import world.landfall.deepspace.ModAttatchments;
import world.landfall.deepspace.ModBlockEntities;
import world.landfall.deepspace.ModBlocks;
import world.landfall.deepspace.ModItems;
import world.landfall.deepspace.dimension.SpaceDimensionType;
import world.landfall.deepspace.integration.CreateIntegration;
import world.landfall.deepspace.planet.PlanetRegistry;
import world.landfall.deepspace.render.SpaceRenderSystem;

@Mod(value="deepspace")
public class Deepspace {
    public static final String MODID = "deepspace";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"deepspace");
    public static final Supplier<CreativeModeTab> TAB = CREATIVE_MODE_TABS.register("deepspace", () -> CreativeModeTab.builder().displayItems((params, output) -> {
        output.accept(ModItems.JETPACK_ITEM);
        output.accept(ModItems.CREATIVE_JETPACK_ITEM.get());
        output.accept(ModItems.JET_HELMET_ITEM);
        output.accept(ModItems.CREATIVE_JET_HELMET_ITEM.get());
        output.accept(ModItems.ANGEL_BLOCK_ITEM);
        output.accept(ModItems.ROCKET_BOOSTER_ITEM);
    }).icon(() -> ModItems.ANGEL_BLOCK_ITEM.toStack()).title((Component)Component.translatable((String)"menu.deepspace.creative_mode_tab")).build());

    public Deepspace(@NotNull IEventBus modEventBus, @NotNull ModContainer modContainer) {
        Objects.requireNonNull(modEventBus, "modEventBus cannot be null");
        Objects.requireNonNull(modContainer, "modContainer cannot be null");
        modEventBus.addListener(this::commonSetup);
        try {
            SpaceDimensionType.register(modEventBus);
            LOGGER.info("Space dimension registered successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to register space dimension", (Throwable)e);
            throw new RuntimeException("Failed to initialize mod", e);
        }
        ModBlocks.register(modEventBus);
        ModArmorMaterials.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModAttatchments.register(modEventBus);
        CreateIntegration.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static ResourceLocation path(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)s);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Performing common setup for Deep Space");
        PlanetRegistry.init();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Deep Space mod server components initialized");
    }

    @EventBusSubscriber(modid="deepspace", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Deep Space mod client initialized");
            SpaceRenderSystem.init();
            LOGGER.info("Initialized renderers");
        }
    }
}

