/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import world.landfall.deepspace.planet.Planet;
import world.landfall.deepspace.planet.PlanetRegistry;
import world.landfall.deepspace.planet.PlanetUtils;

@EventBusSubscriber(modid="deepspace")
public class PlanetCommand {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"planets").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"list").executes(PlanetCommand::listPlanets))).then(Commands.literal((String)"reload").executes(PlanetCommand::reloadPlanets))).then(Commands.literal((String)"sync").executes(PlanetCommand::syncPlanets))).then(Commands.literal((String)"info").executes(PlanetCommand::showPlayerPlanetInfo)));
    }

    private static int listPlanets(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Collection<Planet> planets = PlanetRegistry.getAllPlanets();
        if (planets.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"No planets are currently registered."), false);
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)("Registered planets (" + planets.size() + "):")), false);
        for (Planet planet : planets) {
            Vec3 min = planet.getBoundingBoxMin();
            Vec3 max = planet.getBoundingBoxMax();
            MutableComponent planetInfo = Component.literal((String)String.format("- %s (%s): %s [%.1f,%.1f,%.1f] to [%.1f,%.1f,%.1f]", planet.getName(), planet.getId(), planet.getDimension().location(), min.x, min.y, min.z, max.x, max.y, max.z));
            source.sendSuccess(() -> PlanetCommand.lambda$listPlanets$3((Component)planetInfo), false);
        }
        return planets.size();
    }

    private static int reloadPlanets(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            int oldCount = PlanetRegistry.getPlanetCount();
            PlanetRegistry.loadPlanets();
            int newCount = PlanetRegistry.getPlanetCount();
            PlanetRegistry.syncToAllPlayers();
            source.sendSuccess(() -> Component.literal((String)String.format("Reloaded planets: %d -> %d planets", oldCount, newCount)), true);
            return newCount;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Failed to reload planets: " + e.getMessage())));
            return 0;
        }
    }

    private static int syncPlanets(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            PlanetRegistry.syncToAllPlayers();
            int planetCount = PlanetRegistry.getPlanetCount();
            source.sendSuccess(() -> Component.literal((String)String.format("Synchronized %d planets to all players", planetCount)), true);
            return planetCount;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Failed to sync planets: " + e.getMessage())));
            return 0;
        }
    }

    private static int showPlayerPlanetInfo(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (source.getEntity() == null) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players"));
            return 0;
        }
        Entity entity = source.getEntity();
        if (!(entity instanceof Player)) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players"));
            return 0;
        }
        Player player = (Player)entity;
        Planet currentPlanet = PlanetUtils.getPlayerPlanet(player);
        Vec3 playerPos = player.position();
        if (currentPlanet != null) {
            Vec3 min = currentPlanet.getBoundingBoxMin();
            Vec3 max = currentPlanet.getBoundingBoxMax();
            Vec3 center = currentPlanet.getCenter();
            double distanceToCenter = playerPos.distanceTo(center);
            source.sendSuccess(() -> Component.literal((String)String.format("Current Planet: %s (%s)", currentPlanet.getName(), currentPlanet.getId())), false);
            source.sendSuccess(() -> Component.literal((String)String.format("Dimension: %s", currentPlanet.getDimension().location())), false);
            source.sendSuccess(() -> Component.literal((String)String.format("Bounding Box: [%.1f,%.1f,%.1f] to [%.1f,%.1f,%.1f]", min.x, min.y, min.z, max.x, max.y, max.z)), false);
            source.sendSuccess(() -> Component.literal((String)String.format("Center: [%.1f,%.1f,%.1f] (%.1f blocks away)", center.x, center.y, center.z, distanceToCenter)), false);
            if (!currentPlanet.getDescription().isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)("Description: " + currentPlanet.getDescription())), false);
            }
        } else {
            source.sendSuccess(() -> Component.literal((String)"You are not currently in a registered planet dimension"), false);
            Planet nearestPlanet = PlanetUtils.getNearestPlanet(playerPos);
            if (nearestPlanet != null) {
                double distance = PlanetUtils.getDistanceToNearestPlanet(playerPos);
                source.sendSuccess(() -> Component.literal((String)String.format("Nearest planet: %s (%.1f blocks away)", nearestPlanet.getName(), distance)), false);
            }
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$listPlanets$3(Component planetInfo) {
        return planetInfo;
    }
}

