/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.planet;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Sun {
    public static final Codec<Sun> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.CODEC.fieldOf("boundingBoxMin").forGetter(Sun::getBoundingBoxMin), (App)Vec3.CODEC.fieldOf("boundingBoxMax").forGetter(Sun::getBoundingBoxMax), (App)Codec.DOUBLE.fieldOf("hurtRadius").forGetter(Sun::getHurtRadius)).apply((Applicative)instance, Sun::new));
    private final Vec3 boundingBoxMin;
    private final Vec3 boundingBoxMax;
    private final double hurtRadius;

    public Sun(@NotNull Vec3 _boundingBoxMin, @NotNull Vec3 _boundingBoxMax, double _hurtRadius) {
        this.boundingBoxMin = Objects.requireNonNull(_boundingBoxMin);
        this.boundingBoxMax = Objects.requireNonNull(_boundingBoxMax);
        this.hurtRadius = _hurtRadius;
        if (this.boundingBoxMin.x > this.boundingBoxMax.x || this.boundingBoxMin.y > this.boundingBoxMax.y || this.boundingBoxMin.z > this.boundingBoxMax.z) {
            throw new IllegalArgumentException("Invalid bounding box: minimum coordinates must be less than maximum coordinates");
        }
    }

    public Vec3 getBoundingBoxMin() {
        return this.boundingBoxMin;
    }

    public Vec3 getBoundingBoxMax() {
        return this.boundingBoxMax;
    }

    public double getHurtRadius() {
        return this.hurtRadius;
    }

    public boolean isWithinBounds(@NotNull Vec3 position) {
        Objects.requireNonNull(position, "Position cannot be null");
        return position.x >= this.boundingBoxMin.x && position.x <= this.boundingBoxMax.x && position.y >= this.boundingBoxMin.y && position.y <= this.boundingBoxMax.y && position.z >= this.boundingBoxMin.z && position.z <= this.boundingBoxMax.z;
    }

    public boolean isPlayerTouching(@NotNull Player player) {
        Objects.requireNonNull(player);
        Level level = player.level();
        if (!level.dimension().location().equals((Object)ResourceLocation.parse((String)"deepspace:space"))) {
            return false;
        }
        Vec3 position = player.position();
        return position.x >= this.boundingBoxMin.x - 0.5 && position.x <= this.boundingBoxMax.x + 0.5 && position.y >= this.boundingBoxMin.y - 2.0 && position.y <= this.boundingBoxMax.y && position.z >= this.boundingBoxMin.z - 0.5 && position.z <= this.boundingBoxMax.z + 0.5;
    }

    @NotNull
    public Vec3 getCenter() {
        return new Vec3((this.boundingBoxMin.x + this.boundingBoxMax.x) / 2.0, (this.boundingBoxMin.y + this.boundingBoxMax.y) / 2.0, (this.boundingBoxMin.z + this.boundingBoxMax.z) / 2.0);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        buffer.writeDouble(this.boundingBoxMin.x);
        buffer.writeDouble(this.boundingBoxMin.y);
        buffer.writeDouble(this.boundingBoxMin.z);
        buffer.writeDouble(this.boundingBoxMax.x);
        buffer.writeDouble(this.boundingBoxMax.y);
        buffer.writeDouble(this.boundingBoxMax.z);
        buffer.writeDouble(this.hurtRadius);
    }

    @NotNull
    public static Sun fromNetwork(@NotNull FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "Buffer cannot be null");
        Vec3 boundingBoxMin = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        Vec3 boundingBoxMax = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        double hurtRadius = buffer.readDouble();
        return new Sun(boundingBoxMin, boundingBoxMax, hurtRadius);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Sun sun = (Sun)obj;
        return Objects.equals(sun.boundingBoxMin, this.boundingBoxMin) && Objects.equals(sun.boundingBoxMax, this.boundingBoxMax) && sun.hurtRadius == this.hurtRadius;
    }

    public int hashCode() {
        return Objects.hash(this.boundingBoxMin) ^ Objects.hash(this.boundingBoxMax) ^ Objects.hash(this.hurtRadius);
    }

    public String toString() {
        return "Sun{boundingBoxMin=" + String.valueOf(this.boundingBoxMin) + ", boundingBoxMax=" + String.valueOf(this.boundingBoxMax) + ", hurtRadius=" + this.hurtRadius + "}";
    }
}

