/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.client;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import world.landfall.deepspace.ModAttatchments;
import world.landfall.deepspace.ModItems;
import world.landfall.deepspace.ModKeyMappings;
import world.landfall.deepspace.dimension.SpaceDimensionEffects;
import world.landfall.deepspace.item.JetpackItem;
import world.landfall.deepspace.network.JetpackPacket;

@EventBusSubscriber(modid="deepspace", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class SpaceClientEvents {
    @SubscribeEvent
    public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"deepspace", (String)"space"), (DimensionSpecialEffects)new SpaceDimensionEffects());
    }

    @EventBusSubscriber(modid="deepspace", value={Dist.CLIENT})
    public static class Tick {
        @SubscribeEvent
        public static void onClientTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            ItemStack item = player.getItemBySlot(EquipmentSlot.CHEST);
            if (item.is(ModItems.JETPACK_ITEM) && player.level().isClientSide) {
                JetpackItem.JetpackComponent component = (JetpackItem.JetpackComponent)item.getComponents().get(JetpackItem.JetpackComponent.SUPPLIER.get());
                if (component == null) {
                    return;
                }
                boolean rocketing = Minecraft.getInstance().options.keyJump.isDown() && component.canFly();
                PacketDistributor.sendToServer((CustomPacketPayload)new JetpackPacket.RocketForward(rocketing), (CustomPacketPayload[])new CustomPacketPayload[0]);
                event.getEntity().setData(ModAttatchments.IS_ROCKETING_FORWARD, (Object)rocketing);
                if (((KeyMapping)ModKeyMappings.BEGIN_FLYING.get()).isDown() && component.canFly()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new JetpackPacket.BeginFlying(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    event.getEntity().setData(ModAttatchments.IS_FLYING_JETPACK, (Object)true);
                }
                if (Minecraft.getInstance().options.keyShift.isDown()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new JetpackPacket.BeginFlying(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    event.getEntity().setData(ModAttatchments.IS_FLYING_JETPACK, (Object)false);
                    event.getEntity().setData(ModAttatchments.IS_ROCKETING_FORWARD, (Object)false);
                }
            }
        }

        @SubscribeEvent
        public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            player.setData(ModAttatchments.IS_FLYING_JETPACK, (Object)false);
            player.setData(ModAttatchments.IS_ROCKETING_FORWARD, (Object)false);
        }
    }
}

