/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import world.landfall.deepspace.ModBlocks;

public class AngelBlockItem
extends BlockItem {
    public AngelBlockItem(Item.Properties properties) {
        super((Block)ModBlocks.ANGEL_BLOCK.get(), properties.component(DataComponents.RARITY, (Object)Rarity.RARE));
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        return super.canPlace(context, state);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        InteractionResultHolder result = super.use(level, player, usedHand);
        if (result.getResult() == InteractionResult.PASS) {
            Vec3 direction = player.getLookAngle();
            double reach = player.blockInteractionRange();
            Vec3 normal = direction.normalize();
            Vec3 pos = new Vec3(normal.x, normal.y, normal.z).scale(reach).add(player.position());
            InteractionResult newResult = this.place(new BlockPlaceContext(player, usedHand, player.getUseItem(), new BlockHitResult(pos, Direction.getNearest((double)normal.x, (double)normal.y, (double)normal.z), AngelBlockItem.roundToBlockPos(pos.add(new Vec3(-0.5, 1.0, -0.5))), true)));
            if (!player.isCreative() && (newResult.equals((Object)InteractionResult.SUCCESS) || newResult.equals((Object)InteractionResult.CONSUME))) {
                player.getItemInHand(usedHand).shrink(1);
            }
            if (newResult.equals((Object)InteractionResult.SUCCESS)) {
                return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
            }
        }
        return result;
    }

    private static BlockPos roundToBlockPos(Vec3 input) {
        return new BlockPos((int)Math.round(input.x), (int)Math.round(input.y), (int)Math.round(input.z));
    }
}

