/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import world.landfall.deepspace.ModArmorMaterials;

public class JetHelmetItem
extends ArmorItem {
    public JetHelmetItem() {
        super(ModArmorMaterials.JET_ARMOR_MATERIAL, ArmorItem.Type.HELMET, new Item.Properties().durability(-1).component(JetHelmetComponent.SUPPLIER, (Object)new JetHelmetComponent(100, 100)).component(DataComponents.RARITY, (Object)Rarity.EPIC).component(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)JetHelmetItem.createModTag())));
    }

    private static CompoundTag createModTag() {
        CompoundTag createTag = new CompoundTag();
        CompoundTag data = new CompoundTag();
        data.put("Processing", (Tag)StringTag.valueOf((String)"BLASTING"));
        createTag.put("CreateData", (Tag)data);
        return createTag;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        JetHelmetComponent jetHelmetComponent = (JetHelmetComponent)stack.getComponents().get(JetHelmetComponent.SUPPLIER.get());
        if (jetHelmetComponent == null) {
            return;
        }
        if (jetHelmetComponent.maxOxygen < 0) {
            tooltipComponents.add((Component)Component.translatable((String)"item.deepspace.jet_helmet.tooltip").append((Component)Component.literal((String)"Infinite").setStyle(Style.EMPTY.withColor(0xFF00FFE))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.deepspace.jet_helmet.tooltip").append((Component)Component.literal((String)(jetHelmetComponent.currentOxygen + "/" + jetHelmetComponent.maxOxygen))));
        }
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        boolean equipped;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        boolean bl = equipped = slotId == 39;
        if (equipped && entity instanceof Player && !(player = (Player)entity).isCreative()) {
            int tick = player.tickCount;
            JetHelmetComponent component = (JetHelmetComponent)stack.getComponents().get(JetHelmetComponent.SUPPLIER.get());
            if (component == null) {
                return;
            }
            if (tick % 40 == 0 && component.maxOxygen >= 0) {
                stack.set(JetHelmetComponent.SUPPLIER, (Object)new JetHelmetComponent(component.currentOxygen - 1, component.maxOxygen));
            }
        }
    }

    public Component getName(ItemStack stack) {
        return stack.has(JetHelmetComponent.SUPPLIER) && ((JetHelmetComponent)stack.get(JetHelmetComponent.SUPPLIER.get())).maxOxygen >= 0 ? Component.translatable((String)"item.deepspace.jet_helmet") : Component.translatable((String)"item.deepspace.jet_helmet.creative");
    }

    public boolean isBarVisible(ItemStack stack) {
        JetHelmetComponent component = (JetHelmetComponent)stack.getComponents().get(JetHelmetComponent.SUPPLIER.get());
        return component != null && component.maxOxygen >= 0;
    }

    public int getBarWidth(ItemStack stack) {
        JetHelmetComponent component = (JetHelmetComponent)stack.getComponents().get(JetHelmetComponent.SUPPLIER.get());
        return component != null ? (int)((float)component.playerOxygen() / 300.0f * 12.0f) : 0;
    }

    public int getBarColor(ItemStack stack) {
        JetHelmetComponent component = (JetHelmetComponent)stack.getComponents().get(JetHelmetComponent.SUPPLIER.get());
        return component != null && component.playerOxygen() > 100 ? Color.WHITE.getRGB() : Color.RED.getRGB();
    }

    public record JetHelmetComponent(int currentOxygen, int maxOxygen) {
        public static final Codec<JetHelmetComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("current_oxygen").forGetter(JetHelmetComponent::currentOxygen), (App)Codec.INT.fieldOf("max_oxygen").forGetter(JetHelmetComponent::maxOxygen)).apply((Applicative)instance, JetHelmetComponent::new));
        public static final StreamCodec<ByteBuf, JetHelmetComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, JetHelmetComponent::currentOxygen, (StreamCodec)ByteBufCodecs.INT, JetHelmetComponent::maxOxygen, JetHelmetComponent::new);
        public static final DeferredRegister.DataComponents REGISTRAR = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"deepspace");
        public static final Supplier<DataComponentType<JetHelmetComponent>> SUPPLIER = REGISTRAR.registerComponentType("jet_helmet", builder -> builder.persistent(CODEC).networkSynchronized(STREAM_CODEC));

        public static void register(IEventBus eventBus) {
            REGISTRAR.register(eventBus);
        }

        public int playerOxygen() {
            return this.maxOxygen < 0 ? 300 : (int)Math.clamp((float)this.currentOxygen / (float)this.maxOxygen * 300.0f, 0.0f, 300.0f);
        }
    }
}

