/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerFlyableFallEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import world.landfall.deepspace.ModAttatchments;

@EventBusSubscriber(modid="deepspace")
public class JetpackItem
extends Item
implements Equipable {
    private static Logger LOGGER = LogUtils.getLogger();

    public JetpackItem() {
        super(new Item.Properties().durability(-1).component(JetpackComponent.SUPPLIER, (Object)new JetpackComponent(100, 100)).component(DataComponents.RARITY, (Object)Rarity.EPIC));
    }

    public Component getName(ItemStack stack) {
        return stack.has(JetpackComponent.SUPPLIER) && ((JetpackComponent)stack.get(JetpackComponent.SUPPLIER.get())).maxFuel >= 0 ? Component.translatable((String)"item.deepspace.jetpack") : Component.translatable((String)"item.deepspace.jetpack.creative");
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        boolean inSlot;
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        boolean inSpace = level.dimension().location().equals((Object)ResourceLocation.parse((String)"deepspace:space"));
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int tick = player.tickCount;
        boolean bl = inSlot = slotId == 38;
        if (!(((Boolean)player.getData(ModAttatchments.IS_FLYING_JETPACK)).booleanValue() && ((Boolean)player.getData(ModAttatchments.IS_ROCKETING_FORWARD)).booleanValue() && inSlot)) {
            return;
        }
        if (tick % 5 == 0) {
            player.level().playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.1f, 0.5f);
        }
        if (tick % 20 == 0) {
            JetpackComponent component = (JetpackComponent)stack.getComponents().get(JetpackComponent.SUPPLIER.get());
            if (component == null) {
                return;
            }
            if (component.maxFuel > 0) {
                stack.set(JetpackComponent.SUPPLIER.get(), (Object)new JetpackComponent(component.currentFuel - 1, component.maxFuel));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        JetpackComponent jetpackComponent = (JetpackComponent)stack.getComponents().get(JetpackComponent.SUPPLIER.get());
        if (jetpackComponent == null) {
            return;
        }
        if (jetpackComponent.maxFuel < 0) {
            tooltipComponents.add((Component)Component.translatable((String)"item.deepspace.jetpack.tooltip").append((Component)Component.literal((String)"Infinite").setStyle(Style.EMPTY.withColor(0xFF00FFE))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.deepspace.jetpack.tooltip").append((Component)Component.literal((String)(jetpackComponent.currentFuel + "/" + jetpackComponent.maxFuel))));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        JetpackComponent component = (JetpackComponent)stack.getComponents().get(JetpackComponent.SUPPLIER.get());
        return component != null && component.maxFuel > 0;
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return Color.WHITE.getRGB();
    }

    public int getBarWidth(ItemStack stack) {
        JetpackComponent component = (JetpackComponent)stack.getComponents().get(JetpackComponent.SUPPLIER.get());
        return component != null ? (int)((float)component.currentFuel / (float)component.maxFuel * 12.0f) : 0;
    }

    public static boolean isFlyEnabled(ItemStack stack) {
        JetpackComponent component = (JetpackComponent)stack.getComponents().get(JetpackComponent.SUPPLIER.get());
        if (component == null) {
            LOGGER.error("A jetpack was created without its component !");
            return false;
        }
        return component.currentFuel > 0 || component.maxFuel < 0;
    }

    @SubscribeEvent
    public static void fallFlyEvent(PlayerFlyableFallEvent event) {
    }

    public record JetpackComponent(int currentFuel, int maxFuel) {
        public static final Codec<JetpackComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("current_fuel").forGetter(JetpackComponent::currentFuel), (App)Codec.INT.fieldOf("max_fuel").forGetter(JetpackComponent::maxFuel)).apply((Applicative)instance, JetpackComponent::new));
        public static final StreamCodec<ByteBuf, JetpackComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, JetpackComponent::currentFuel, (StreamCodec)ByteBufCodecs.INT, JetpackComponent::maxFuel, JetpackComponent::new);
        public static final DeferredRegister.DataComponents REGISTRAR = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"deepspace");
        public static final Supplier<DataComponentType<JetpackComponent>> SUPPLIER = REGISTRAR.registerComponentType("jetpack", builder -> builder.persistent(CODEC).networkSynchronized(STREAM_CODEC));

        public static void register(IEventBus eventBus) {
            REGISTRAR.register(eventBus);
        }

        public boolean canFly() {
            return this.maxFuel < 0 || this.currentFuel > 0;
        }
    }
}

