/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.item;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import world.landfall.deepspace.ModAttatchments;

public class RocketBoosterItem
extends Item {
    public RocketBoosterItem() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        player.setData(ModAttatchments.IS_FLYING_JETPACK, (Object)true);
        Vector3f velocity = (Vector3f)player.getData(ModAttatchments.JETPACK_VELOCITY);
        ItemStack item = player.getItemInHand(usedHand);
        Vector3f newVelocity = player.getLookAngle().toVector3f().mul(2.0f);
        player.setData(ModAttatchments.JETPACK_VELOCITY, (Object)new Vector3f((Vector3fc)velocity).add((Vector3fc)newVelocity));
        player.getCooldowns().addCooldown(item.getItem(), 40);
        item.consume(1, (LivingEntity)player);
        player.level().playSound(player, player.position().x, player.position().y, player.position().z, SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.PLAYERS);
        RandomSource random = level.getRandom();
        for (int i = 0; i < 128; ++i) {
            Vector3f offset = new Vector3f(random.nextFloat() * 2.0f - 1.0f, random.nextFloat() * 2.0f - 1.0f, random.nextFloat() * 2.0f - 1.0f).mul(0.4f);
            Vector3f oppositeForce = new Vector3f((Vector3fc)newVelocity).normalize().mul(-0.1f);
            offset.sub((Vector3fc)oppositeForce.mul(2.0f));
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, player.getX() + (double)offset.x + (double)(oppositeForce.x * (float)i), player.getY() + (double)offset.y + (double)(oppositeForce.y * (float)i), player.getZ() + (double)offset.z + (double)(oppositeForce.z * (float)i), (double)oppositeForce.x, (double)oppositeForce.y, (double)oppositeForce.z);
        }
        return InteractionResultHolder.consume((Object)item);
    }
}

