/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.planet;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import world.landfall.deepspace.planet.PlanetRegistry;
import world.landfall.deepspace.planet.Sun;

@EventBusSubscriber(modid="deepspace")
public class SunHurtHandler {
    @SubscribeEvent
    public static void serverPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().getServer() == null) {
            return;
        }
        Player player = event.getEntity();
        Sun sun = PlanetRegistry.getSun();
        ResourceLocation dimension = player.level().dimension().location();
        if (sun == null) {
            return;
        }
        if (sun.isPlayerTouching(player) && dimension.equals((Object)ResourceLocation.parse((String)"deepspace:space"))) {
            player.hurt(player.damageSources().inFire(), Float.MAX_VALUE);
        }
        if (player.position().distanceTo(sun.getCenter()) <= sun.getHurtRadius() && dimension.equals((Object)ResourceLocation.parse((String)"deepspace:space"))) {
            player.setRemainingFireTicks(20);
        }
    }
}

