/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import foundry.veil.api.client.render.MatrixStack;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3fc;
import org.slf4j.Logger;
import world.landfall.deepspace.Deepspace;
import world.landfall.deepspace.ModOptions;
import world.landfall.deepspace.integration.IrisIntegration;
import world.landfall.deepspace.planet.Planet;
import world.landfall.deepspace.planet.PlanetRegistry;
import world.landfall.deepspace.planet.Sun;
import world.landfall.deepspace.render.SpaceRenderSystem;
import world.landfall.deepspace.render.shapes.Cube;

public class PlanetRenderer {
    private static final Logger logger = LogUtils.getLogger();
    private static final HashMap<String, Cube> MESHES = new HashMap();
    private static final HashMap<String, ResourceLocation> TEXTURES = new HashMap();
    private static final ResourceLocation PLANET_SHADER = Deepspace.path("planet");
    private static final RenderStateShard.ShaderStateShard PLANET_RENDER_TYPE = new RenderStateShard.ShaderStateShard(() -> {
        ShaderProgram shader = VeilRenderSystem.setShader((ResourceLocation)PLANET_SHADER);
        return VeilRenderBridge.toShaderInstance((ShaderProgram)shader);
    });
    private static final ResourceLocation PLANET_UNSHADED_SHADER = Deepspace.path("planet_unshaded");
    private static final RenderStateShard.ShaderStateShard PLANET_UNSHADED_RENDER_TYPE = new RenderStateShard.ShaderStateShard(() -> {
        ShaderProgram shader = VeilRenderSystem.setShader((ResourceLocation)PLANET_UNSHADED_SHADER);
        return VeilRenderBridge.toShaderInstance((ShaderProgram)shader);
    });

    public static RenderType planetRenderType() {
        RenderType.CompositeState renderType = RenderType.CompositeState.builder().setShaderState(PLANET_RENDER_TYPE).createCompositeState(true);
        return RenderType.create((String)"planet", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)renderType);
    }

    public static RenderType planetUnshadedRenderType() {
        RenderType.CompositeState renderType = RenderType.CompositeState.builder().setShaderState(PLANET_UNSHADED_RENDER_TYPE).createCompositeState(true);
        return RenderType.create((String)"planet_unshaded", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)786432, (boolean)true, (boolean)false, (RenderType.CompositeState)renderType);
    }

    public static void refreshMeshes() {
        MESHES.clear();
        TEXTURES.clear();
        for (Planet x : PlanetRegistry.getAllPlanets()) {
            MESHES.put(x.getId(), new Cube(x.getBoundingBoxMin().toVector3f(), x.getBoundingBoxMax().toVector3f(), 1.0f, false));
            TEXTURES.put(x.getId(), Deepspace.path("textures/" + x.getId() + ".png"));
            logger.info("Made mesh for planet {}", (Object)x.getName());
        }
    }

    public static void render(VeilRenderLevelStageEvent.Stage stage, LevelRenderer levelRenderer, MultiBufferSource.BufferSource bufferSource, MatrixStack matrixStack, Matrix4fc frustumMatrix, Matrix4fc projectionMatrix, int renderTick, DeltaTracker partialTicks, Camera camera, Frustum frustum) {
        Minecraft instance = Minecraft.getInstance();
        if (!instance.level.dimension().location().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"deepspace", (String)"space"))) {
            return;
        }
        RenderType planetRenderType = PlanetRenderer.planetRenderType();
        RenderType planetUnshadedRenderType = PlanetRenderer.planetUnshadedRenderType();
        PoseStack poseStack = matrixStack.toPoseStack();
        for (Map.Entry<String, Cube> x : MESHES.entrySet()) {
            BufferBuilder planetBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.NEW_ENTITY);
            ResourceLocation texture = TEXTURES.get(x.getKey());
            Sun sun = PlanetRegistry.getSun();
            Vec3 center = sun.getCenter();
            VeilRenderSystem.setShader((ResourceLocation)Deepspace.path("planet")).getOrCreateUniform((CharSequence)"SunPosition").setVector((Vector3fc)center.toVector3f().sub((Vector3fc)camera.getPosition().toVector3f()));
            x.getValue().render(poseStack, (VertexConsumer)planetBuilder, (Vector3fc)camera.getPosition().toVector3f().mul(-1.0f), new Quaternionf());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IrisIntegration.bindPipeline();
            switch (ModOptions.options().shadingDetail) {
                case NONE: {
                    planetUnshadedRenderType.draw(planetBuilder.buildOrThrow());
                    break;
                }
                case BASIC: 
                case EXPENSIVE: {
                    planetRenderType.draw(planetBuilder.buildOrThrow());
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void init() {
        PlanetRenderer.refreshMeshes();
        SpaceRenderSystem.registerRenderer(PlanetRenderer::render, VeilRenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS);
    }

    private static Matrix4f projectionMatrix(double fov, GameRenderer gameRenderer) {
        Matrix4f mat = new Matrix4f();
        return mat.perspective((float)(fov * 0.01745329238474369), (float)gameRenderer.getMinecraft().getWindow().getWidth() / (float)gameRenderer.getMinecraft().getWindow().getHeight(), 0.05f, gameRenderer.getDepthFar() * 4.0f);
    }
}

