/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.deepspace.mixin;

import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.AirFlowParticleData;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import world.landfall.deepspace.integration.CreateIntegration;

@Mixin(value={AirCurrent.class}, remap=false)
public abstract class MixinAirCurrent {
    @Shadow
    public final IAirCurrentSource source;
    @Shadow
    protected List<Entity> caughtEntities = new ArrayList<Entity>();
    @Shadow
    public boolean pushing;
    @Shadow
    public float maxDistance;
    @Shadow
    public Direction direction;
    @Shadow
    protected List<Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>> affectedItemHandlers;

    protected MixinAirCurrent(IAirCurrentSource source) {
        this.source = source;
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"}, remap=false)
    private void init(CallbackInfo ci) {
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"}, remap=false, cancellable=true)
    private void tick(CallbackInfo ci) {
        Level world;
        if (this.direction == null) {
            this.rebuild();
        }
        if ((world = this.source.getAirCurrentWorld()) != null && world.isClientSide) {
            float offset = this.pushing ? 0.5f : this.maxDistance + 0.5f;
            Vec3 pos = VecHelper.getCenterOf((Vec3i)this.source.getAirCurrentPos()).add(Vec3.atLowerCornerOf((Vec3i)this.direction.getNormal()).scale((double)offset));
            if ((double)world.random.nextFloat() < (Double)AllConfigs.client().fanParticleDensity.get()) {
                world.addParticle((ParticleOptions)new AirFlowParticleData((Vec3i)this.source.getAirCurrentPos()), pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
        }
        this.tickAffectedEntities(world);
        this.tickAffectedHandlers();
        CreateIntegration.handleAir(this.caughtEntities);
        ci.cancel();
    }

    @Shadow
    public abstract void rebuild();

    @Shadow
    protected abstract void tickAffectedEntities(Level var1);

    @Shadow
    public abstract void tickAffectedHandlers();
}

