/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.block;

import com.mojang.serialization.MapCodec;
import dev.enjarai.trickster.block.ModBlocks;
import dev.enjarai.trickster.block.ScrollShelfBlockEntity;
import dev.enjarai.trickster.item.ModItems;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_241;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class ScrollShelfBlock
extends class_2237 {
    public static final int GRID_WIDTH = 3;
    public static final int GRID_HEIGHT = 3;
    public static final class_2753 FACING = class_2741.field_12481;

    protected ScrollShelfBlock() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9632(1.5f).method_9626(class_2498.field_41085).method_50013());
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public static OptionalInt getSlotForHitPos(class_3965 hit, class_2680 state) {
        return ScrollShelfBlock.getHitPos(hit, (class_2350)state.method_11654((class_2769)class_2383.field_11177)).map(hitPos -> {
            int x = Math.clamp((long)((int)(hitPos.field_1343 * 3.0f)), 0, 2);
            int y = Math.clamp((long)((int)(hitPos.field_1342 * 3.0f)), 0, 2);
            return OptionalInt.of(x + y * 3);
        }).orElseGet(OptionalInt::empty);
    }

    public static Optional<class_241> getHitPos(class_3965 hit, class_2350 facing) {
        class_2350 direction = hit.method_17780();
        if (facing != direction) {
            return Optional.empty();
        }
        class_2338 blockPos = hit.method_17777().method_10093(direction);
        class_243 vec3d = hit.method_17784().method_1023((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        double d = vec3d.method_10216();
        double e = vec3d.method_10214();
        double f = vec3d.method_10215();
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043 -> Optional.of(new class_241((float)(1.0 - d), (float)e));
            case class_2350.field_11035 -> Optional.of(new class_241((float)d, (float)e));
            case class_2350.field_11039 -> Optional.of(new class_241((float)f, (float)e));
            case class_2350.field_11034 -> Optional.of(new class_241((float)(1.0 - f), (float)e));
            case class_2350.field_11033, class_2350.field_11036 -> Optional.empty();
        };
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ScrollShelfBlockEntity) {
            ScrollShelfBlockEntity blockEntity = (ScrollShelfBlockEntity)class_25862;
            if (!stack.method_31573(ModItems.SCROLLS)) {
                return class_9062.field_47731;
            }
            OptionalInt slot = ScrollShelfBlock.getSlotForHitPos(hit, state);
            if (slot.isEmpty()) {
                return class_9062.field_47732;
            }
            class_1799 slotStack = blockEntity.method_5438(slot.getAsInt());
            if (!slotStack.method_7960()) {
                return class_9062.field_47731;
            }
            ScrollShelfBlock.tryAddBook(world, pos, player, blockEntity, stack, slot.getAsInt());
            return class_9062.method_55644((boolean)world.field_9236);
        }
        return class_9062.field_47732;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ScrollShelfBlockEntity) {
            ScrollShelfBlockEntity blockEntity = (ScrollShelfBlockEntity)class_25862;
            OptionalInt slot = ScrollShelfBlock.getSlotForHitPos(hit, state);
            if (slot.isEmpty()) {
                return class_1269.field_5811;
            }
            if (blockEntity.method_5438(slot.getAsInt()).method_7960()) {
                return class_1269.field_21466;
            }
            ScrollShelfBlock.tryRemoveBook(world, pos, player, blockEntity, slot.getAsInt());
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    private static void tryAddBook(class_1937 world, class_2338 pos, class_1657 player, ScrollShelfBlockEntity blockEntity, class_1799 stack, int slot) {
        if (!world.field_9236) {
            player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            blockEntity.method_5447(slot, stack.method_7971(stack.method_7947()));
            world.method_8396(null, pos, class_3417.field_40971, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    private static void tryRemoveBook(class_1937 world, class_2338 pos, class_1657 player, ScrollShelfBlockEntity blockEntity, int slot) {
        if (!world.field_9236) {
            class_1799 itemStack = blockEntity.method_5434(slot, 1);
            world.method_8396(null, pos, class_3417.field_40971, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_31548().method_7394(itemStack)) {
                player.method_7328(itemStack, false);
            }
            world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
        }
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return MapCodec.unit((Object)((Object)ModBlocks.SCROLL_SHELF));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ScrollShelfBlockEntity(pos, state);
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            ScrollShelfBlockEntity shelfEntity;
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof ScrollShelfBlockEntity && !(shelfEntity = (ScrollShelfBlockEntity)blockEntity).method_5442()) {
                for (int i = 0; i < shelfEntity.method_5439(); ++i) {
                    class_1799 itemStack = shelfEntity.method_5438(i);
                    if (itemStack.method_7960()) continue;
                    class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)itemStack);
                }
                shelfEntity.method_5448();
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        if (world.method_8608()) {
            return 0;
        }
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }
}

