/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.cca;

import dev.enjarai.trickster.cca.ModEntityComponents;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class BarsComponent
implements ServerTickingComponent,
AutoSyncedComponent {
    public static final int STAY_FOR_TICKS = 100;
    public static final Endec<Map<Integer, Bar>> BARS_ENDEC = Endec.map((Endec)Endec.INT, Bar.ENDEC);
    private final class_1657 player;
    private final Int2ObjectMap<Bar> bars = new Int2ObjectOpenHashMap();
    private int lastBarsHashcode;
    private class_5321<class_1937> lastPlayerWorld;

    public BarsComponent(class_1657 player) {
        this.player = player;
    }

    public void serverTick() {
        ObjectIterator iterator = this.bars.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            if (((Bar)entry.getValue()).age >= 100) {
                iterator.remove();
                continue;
            }
            ++((Bar)entry.getValue()).age;
        }
        ModEntityComponents.BARS.sync((Object)this.player);
    }

    public Int2ObjectMap<Bar> getBars() {
        return this.bars;
    }

    public void setBar(int id, double fill) {
        Bar bar = (Bar)this.bars.computeIfAbsent(id, i -> new Bar(fill));
        bar.fill = fill;
        bar.age = 0;
    }

    public void clearBar(int id) {
        this.bars.remove(id);
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public boolean shouldSyncWith(class_3222 player) {
        if (player != this.player) {
            return false;
        }
        int hash = this.bars.hashCode();
        class_5321 worldKey = player.method_37908().method_27983();
        if (hash != this.lastBarsHashcode || worldKey != this.lastPlayerWorld) {
            this.lastBarsHashcode = hash;
            this.lastPlayerWorld = worldKey;
            return true;
        }
        return false;
    }

    public void applySyncPacket(class_9129 buf) {
        this.bars.clear();
        this.bars.putAll((Map)buf.read(BARS_ENDEC));
    }

    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        buf.write(BARS_ENDEC, this.bars);
    }

    public static class Bar {
        public static final Endec<Bar> ENDEC = StructEndecBuilder.of((StructField)Endec.DOUBLE.fieldOf("fill", b -> b.fill), Bar::new);
        public double fill;
        public int age;

        public Bar(double fill) {
            this(fill, 0);
        }

        public Bar(double fill, int age) {
            this.fill = fill;
            this.age = age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bar bar = (Bar)o;
            return Double.compare(this.fill, bar.fill) == 0;
        }

        public int hashCode() {
            return Double.hashCode(this.fill) + 1;
        }
    }
}

