/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.cca;

import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.ModSounds;
import dev.enjarai.trickster.cca.ModEntityComponents;
import dev.enjarai.trickster.item.ModItems;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellExecutor;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.execution.PlayerSpellExecutionManager;
import dev.enjarai.trickster.spell.execution.SpellQueueResult;
import dev.enjarai.trickster.spell.execution.executor.ErroredSpellExecutor;
import dev.enjarai.trickster.spell.execution.source.PlayerSpellSource;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class CasterComponent
implements ServerTickingComponent,
AutoSyncedComponent {
    private final class_1657 player;
    private PlayerSpellExecutionManager executionManager;
    private PlayerSpellExecutionManager collarExecutionManager;
    private final Int2ObjectMap<RunningSpellData> runningSpellData = new Int2ObjectOpenHashMap();
    private int lastSentSpellDataHash;
    private class_5321<class_1937> lastPlayerWorld;
    private int wait;
    public static final Endec<Map<Integer, RunningSpellData>> SPELL_DATA_ENDEC = Endec.map((Endec)Endec.INT, (Endec)StructEndecBuilder.of((StructField)Endec.INT.fieldOf("executions_last_tick", RunningSpellData::executionsLastTick), (StructField)Endec.BOOLEAN.fieldOf("errored", RunningSpellData::errored), (StructField)EndecTomfoolery.safeOptionalOf(MinecraftEndecs.TEXT).optionalFieldOf("message", RunningSpellData::message, Optional.empty()), RunningSpellData::new));
    public static final KeyedEndec<PlayerSpellExecutionManager> EXECUTION_MANAGER_ENDEC = PlayerSpellExecutionManager.ENDEC.keyed("manager", () -> new PlayerSpellExecutionManager(5));
    public static final KeyedEndec<PlayerSpellExecutionManager> COLLAR_EXECUTION_MANAGER_ENDEC = PlayerSpellExecutionManager.ENDEC.keyed("collar_manager", () -> new PlayerSpellExecutionManager(1));

    public CasterComponent(class_1657 player) {
        this.player = player;
        this.executionManager = new PlayerSpellExecutionManager(5);
        this.collarExecutionManager = new PlayerSpellExecutionManager(1);
    }

    public void serverTick() {
        if (this.wait > 0) {
            --this.wait;
            return;
        }
        if (this.player.accessoriesCapability() == null || !this.player.accessoriesCapability().isEquipped((class_1792)ModItems.COLLAR)) {
            this.collarExecutionManager.killAll();
        }
        this.runningSpellData.clear();
        this.executionManager.tick(new PlayerSpellSource((class_3222)this.player, this.executionManager), this::afterExecutorTick, this::completeExecutor, this::executorError);
        this.collarExecutionManager.tick(new PlayerSpellSource((class_3222)this.player, this.collarExecutionManager), (i, e) -> {}, this::completeExecutor, this::executorError);
        ModEntityComponents.CASTER.sync((Object)this.player);
    }

    private void afterExecutorTick(int index, SpellExecutor executor) {
        class_2561 message = null;
        boolean errored = false;
        if (executor instanceof ErroredSpellExecutor) {
            ErroredSpellExecutor error = (ErroredSpellExecutor)executor;
            message = error.errorMessage();
            errored = true;
        }
        this.runningSpellData.put(index, (Object)new RunningSpellData(executor.getLastRunExecutions(), errored, Optional.ofNullable(message)));
    }

    private void completeExecutor(int index, SpellExecutor executor) {
        this.playCastSound(1.2f, 0.1f);
    }

    private void executorError(int index, SpellExecutor executor) {
        this.playCastSound(0.5f, 0.1f);
    }

    public void playCastSound(float startPitch, float pitchRange) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            serverPlayer.method_51469().method_43129(null, (class_1297)serverPlayer, ModSounds.CAST, class_3419.field_15248, 1.0f, ModSounds.randomPitch(startPitch, pitchRange));
        }
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.executionManager = (PlayerSpellExecutionManager)tag.get(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{EndecTomfoolery.CODEC_SAFE}), EXECUTION_MANAGER_ENDEC);
        this.collarExecutionManager = (PlayerSpellExecutionManager)tag.get(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{EndecTomfoolery.CODEC_SAFE}), COLLAR_EXECUTION_MANAGER_ENDEC);
        this.waitTicks(20);
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.put(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{EndecTomfoolery.CODEC_SAFE}), EXECUTION_MANAGER_ENDEC, (Object)this.executionManager);
        tag.put(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{EndecTomfoolery.CODEC_SAFE}), COLLAR_EXECUTION_MANAGER_ENDEC, (Object)this.collarExecutionManager);
    }

    public boolean shouldSyncWith(class_3222 player) {
        if (player != this.player) {
            return false;
        }
        int hash = this.runningSpellData.hashCode();
        class_5321 worldKey = player.method_37908().method_27983();
        if (hash != this.lastSentSpellDataHash || worldKey != this.lastPlayerWorld) {
            this.lastSentSpellDataHash = hash;
            this.lastPlayerWorld = worldKey;
            return true;
        }
        return false;
    }

    public void applySyncPacket(class_9129 buf) {
        this.runningSpellData.clear();
        this.runningSpellData.putAll((Map)buf.read(SPELL_DATA_ENDEC));
    }

    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        buf.write(SPELL_DATA_ENDEC, this.runningSpellData);
    }

    public Optional<Integer> queueSpell(SpellPart spell, List<Fragment> arguments) {
        this.playCastSound(0.8f, 0.1f);
        return this.executionManager.queue(spell, arguments);
    }

    public Optional<Integer> queueCollarSpell(SpellPart spell, List<Fragment> arguments) {
        this.playCastSound(0.8f, 0.1f);
        return this.collarExecutionManager.queue(spell, arguments);
    }

    public SpellQueueResult queueSpellAndCast(SpellPart spell, List<Fragment> arguments, Optional<MutableManaPool> poolOverride) {
        this.playCastSound(0.8f, 0.1f);
        return this.executionManager.queueAndCast(new PlayerSpellSource((class_3222)this.player, this.executionManager), spell, arguments, poolOverride);
    }

    public SpellQueueResult queueSpellAndCastSilently(SpellPart spell, List<Fragment> arguments, Optional<MutableManaPool> poolOverride) {
        return this.executionManager.queueAndCast(new PlayerSpellSource((class_3222)this.player, this.executionManager), spell, arguments, poolOverride);
    }

    public void killAll() {
        this.executionManager.killAll();
    }

    public void kill(int index) {
        this.executionManager.kill(index);
    }

    public void killCollar() {
        this.collarExecutionManager.killAll();
    }

    public PlayerSpellExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public void waitTicks(int ticks) {
        this.wait += ticks;
    }

    public Int2ObjectMap<RunningSpellData> getRunningSpellData() {
        return this.runningSpellData;
    }

    public record RunningSpellData(int executionsLastTick, boolean errored, Optional<class_2561> message) {
        @Override
        public int hashCode() {
            int result = Objects.hash(1, this.executionsLastTick);
            result = 31 * result + Boolean.hashCode(this.errored);
            result = 31 * result + Objects.hashCode(this.message);
            return result;
        }
    }
}

