/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.cca;

import dev.enjarai.trickster.cca.ModEntityComponents;
import dev.enjarai.trickster.fleck.Fleck;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class FlecksComponent
implements ServerTickingComponent,
ClientTickingComponent,
AutoSyncedComponent {
    private static final Endec<Map<Integer, FleckEntry>> FLECKS_ENDEC = Endec.map((Endec)Endec.INT, FleckEntry.ENDEC);
    private static final Integer STAY_FOR_TICKS = 20;
    private final class_1657 player;
    private final Int2ObjectMap<FleckEntry> flecks = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<FleckEntry> clientFlecks = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<FleckEntry> prevClientFlecks = new Int2ObjectOpenHashMap();
    private boolean dirty;

    public FlecksComponent(class_1657 player) {
        this.player = player;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public boolean shouldSyncWith(class_3222 player) {
        return player == this.player;
    }

    public void applySyncPacket(class_9129 buf) {
        Map map = (Map)buf.read(FLECKS_ENDEC);
        this.flecks.clear();
        this.flecks.putAll(map);
    }

    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        buf.write(FLECKS_ENDEC, this.flecks);
    }

    public void addFleck(int id, Fleck fleck) {
        this.flecks.put(id, (Object)new FleckEntry(fleck, STAY_FOR_TICKS));
        this.markDirty();
    }

    public void removeFleck(int id) {
        this.flecks.remove(id);
        this.markDirty();
    }

    public List<FleckPair> getRenderFlecks() {
        return this.clientFlecks.int2ObjectEntrySet().stream().map(e -> {
            FleckEntry current = (FleckEntry)e.getValue();
            FleckEntry old = (FleckEntry)this.prevClientFlecks.get(e.getIntKey());
            return new FleckPair(e.getIntKey(), current.fleck(), old == null ? null : old.fleck());
        }).toList();
    }

    public Int2ObjectMap<FleckEntry> getFlecks() {
        return this.flecks;
    }

    private void markDirty() {
        this.dirty = true;
    }

    public void clientTick() {
        this.prevClientFlecks.clear();
        this.prevClientFlecks.putAll(this.clientFlecks);
        this.clientFlecks.clear();
        this.clientFlecks.putAll(this.flecks);
        this.commonTick();
    }

    private void commonTick() {
        ObjectIterator iterator = this.flecks.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            int life = ((FleckEntry)entry.getValue()).life();
            Fleck fleck = ((FleckEntry)entry.getValue()).fleck;
            if (--life >= 0) {
                entry.setValue((Object)new FleckEntry(fleck, life));
                continue;
            }
            iterator.remove();
        }
    }

    public void serverTick() {
        if (this.dirty) {
            ModEntityComponents.FLECKS.sync((Object)this.player);
            this.dirty = false;
        }
        this.commonTick();
    }

    public record FleckEntry(Fleck fleck, int life) {
        public static final Endec<FleckEntry> ENDEC = StructEndecBuilder.of((StructField)Fleck.ENDEC.fieldOf("fleck", FleckEntry::fleck), (StructField)Endec.INT.fieldOf("life", FleckEntry::life), FleckEntry::new);
    }

    public record FleckPair(int id, Fleck current, @Nullable Fleck old) {
    }
}

