/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.coleus;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.render.SpellCircleRenderer;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.type.Signature;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.Tag;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.joml.Vector2f;

@Environment(value=EnvType.CLIENT)
public class Components {
    public static Tag<?> pattern(Pattern pattern, int size) {
        ContainerTag svg = (ContainerTag)((ContainerTag)((ContainerTag)TagCreator.tag((String)"svg").attr("version", (Object)"1.1")).attr("viewbox", (Object)String.format("0 0 %d %d", size, size))).attr("xmlns", (Object)"http://www.w3.org/2000/svg");
        float patternSize = (float)size * 0.46f;
        float x = ((float)size - patternSize * 2.0f) / 2.0f;
        float y = ((float)size - patternSize * 2.0f) / 2.0f;
        boolean[] dotTerminalStatus = pattern.dotTerminalStatus();
        for (int i = 0; i < 9; ++i) {
            Vector2f pos = SpellCircleRenderer.getPatternDotPosition(x + patternSize + 4.0f, y + patternSize + 4.0f, i, patternSize);
            boolean isLinked = pattern.contains(i);
            int dotSize = size / 50;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (dotTerminalStatus[i] && Trickster.CONFIG.dotEmphasis()) {
                r = Trickster.CONFIG.dotEmphasisColor().red();
                g = Trickster.CONFIG.dotEmphasisColor().green();
                b = Trickster.CONFIG.dotEmphasisColor().blue();
            }
            Tag<?> polygon = Components.drawPolygon(pos.x - (float)dotSize, pos.y - (float)dotSize, pos.x - (float)dotSize, pos.y + (float)dotSize, pos.x + (float)dotSize, pos.y + (float)dotSize, pos.x + (float)dotSize, pos.y - (float)dotSize, isLinked ? 0.9f : 0.5f);
            svg.with(polygon);
        }
        for (Pattern.PatternEntry line : pattern.entries()) {
            Vector2f now = SpellCircleRenderer.getPatternDotPosition(x + patternSize + 4.0f, y + patternSize + 4.0f, line.p1(), patternSize);
            Vector2f last = SpellCircleRenderer.getPatternDotPosition(x + patternSize + 4.0f, y + patternSize + 4.0f, line.p2(), patternSize);
            Tag<?> lineSvg = Components.drawLine(last, now, (float)size / 50.0f);
            svg.with(lineSvg);
        }
        return svg.withClass("pattern");
    }

    public static Tag<?> signature(Signature<?> signature) {
        return mod.master_bw3.coleus.Components.text((class_2561)signature.asText());
    }

    private static Tag<?> drawPolygon(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float alpha) {
        return ((ContainerTag)TagCreator.tag((String)"polygon").attr("points", (Object)String.format("%f,%f %f,%f %f,%f %f,%f", Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3), Float.valueOf(x4), Float.valueOf(y4)))).withStyle("opacity: " + alpha);
    }

    private static Tag<?> drawLine(Vector2f last, Vector2f now, float pixelSize) {
        Vector2f directionVec = new Vector2f(last.x - now.x, last.y - now.y).normalize().mul(pixelSize * 3.0f);
        Vector2f lineStart = new Vector2f(last.x - directionVec.x, last.y - directionVec.y);
        Vector2f lineEnd = new Vector2f(now.x + directionVec.x, now.y + directionVec.y);
        return ((ContainerTag)((ContainerTag)((ContainerTag)TagCreator.tag((String)"line").attr("x1", (Object)Float.valueOf(lineStart.x))).attr("y1", (Object)Float.valueOf(lineStart.y))).attr("x2", (Object)Float.valueOf(lineEnd.x))).attr("y2", (Object)Float.valueOf(lineEnd.y));
    }
}

