/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.coleus;

import dev.enjarai.trickster.coleus.Components;
import dev.enjarai.trickster.screen.owo.ManaCostComponent;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.trick.Tricks;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.IframeTag;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mod.master_bw3.coleus.PageContext;
import mod.master_bw3.coleus.SearchEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class TricksterTemplateExpanders {
    public static DomContent patternTemplate(Map<String, String> properties, PageContext context) {
        if (!properties.containsKey("pattern")) {
            return TagCreator.text((String)"");
        }
        Pattern pattern = Pattern.from(Arrays.stream(properties.get("pattern").split(",")).map(s -> Byte.valueOf(s, 10)).toList());
        DivTag div = (DivTag)TagCreator.div().withClass("trick");
        if (properties.containsKey("title")) {
            div.with((DomContent)TagCreator.h2((String)properties.get("title")));
        }
        div.with(Components.pattern(pattern, 400));
        return div;
    }

    public static DomContent glyphTemplate(Map<String, String> properties, PageContext context) {
        if (!properties.containsKey("trick-id")) {
            return TagCreator.text((String)"");
        }
        class_2960 trickId = class_2960.method_60654((String)properties.get("trick-id"));
        Trick trick = (Trick)Tricks.REGISTRY.method_10223(trickId);
        return Components.pattern(trick.getPattern(), 400);
    }

    public static DomContent revisionTemplate(Map<String, String> properties, PageContext context) {
        String title = properties.get("title");
        String id = title.toLowerCase().replaceAll("[^a-z0-9]", "");
        Pattern pattern = Pattern.from(Arrays.stream(properties.get("pattern").split(",")).map(s -> Byte.valueOf(s, 10)).toList());
        context.addSearchEntry(new SearchEntry(title, "", String.valueOf(context.getBookDir().relativize(context.getPagePath())) + "#" + id, List.of()));
        DivTag trickContainer = (DivTag)((DivTag)((DivTag)TagCreator.div().withClass("trick")).withId(id)).with(new DomContent[]{TagCreator.h2((String)title), Components.pattern(pattern, 400), TagCreator.span((String)"(Scribing Pattern)").withClass("gray")});
        DivTag manaCostContainer = (DivTag)TagCreator.div().withClass("cost-rule embedded-component-container");
        String texture = properties.getOrDefault("texture", properties.get("book-texture"));
        TextureComponent component = io.wispforest.owo.ui.component.Components.texture((class_2960)class_2960.method_60654((String)texture), (int)54, (int)183, (int)109, (int)3, (int)512, (int)256).blend(true);
        manaCostContainer.with((DomContent)mod.master_bw3.coleus.Components.owo((Component)Containers.verticalFlow((Sizing)Sizing.fixed((int)112), (Sizing)Sizing.fixed((int)8)).child((Component)component).padding(Insets.of((int)2, (int)0, (int)0, (int)0)), (Path)context.getPagePath(), (Path)context.getAssetsDir().resolve(id + "-mana-cost.png"), (int)500, (int)2).withClass("embedded-component"));
        trickContainer.with((DomContent)manaCostContainer);
        return trickContainer;
    }

    public static DomContent trickTemplate(Map<String, String> properties, PageContext context) {
        class_2960 trickId = class_2960.method_60654((String)properties.get("trick-id"));
        Trick trick = (Trick)Tricks.REGISTRY.method_10223(trickId);
        context.addSearchEntry(new SearchEntry(trick.getName().getString(), trick.getSignatures().stream().map(signature -> signature.asText().getString()).collect(Collectors.joining("\n")), String.valueOf(context.getBookDir().relativize(context.getPagePath())) + "#" + String.valueOf(trickId), List.of()));
        DivTag trickContainer = (DivTag)((DivTag)((DivTag)((DivTag)TagCreator.div().withClass("trick")).withId(trickId.toString())).with(new DomContent[]{TagCreator.h2((String)trick.getName().getString()), Components.pattern(trick.getPattern(), 400)})).with(trick.getSignatures().stream().flatMap(signature -> Arrays.stream(new DomContent[]{TagCreator.br(), TagCreator.br(), Components.signature(signature).withClass("signature")})));
        DivTag manaCostContainer = (DivTag)TagCreator.div().withClass("cost-rule embedded-component-container");
        String texture = properties.getOrDefault("texture", properties.get("book-texture"));
        boolean hasCost = properties.containsKey("cost");
        if (hasCost) {
            ManaCostComponent component = new ManaCostComponent(properties.get("cost"), class_2960.method_60654((String)texture));
            manaCostContainer.with(new DomContent[]{mod.master_bw3.coleus.Components.owo((Component)Containers.verticalFlow((Sizing)Sizing.fixed((int)112), (Sizing)Sizing.fixed((int)8)).child((Component)component).padding(Insets.of((int)2, (int)0, (int)0, (int)0)), (Path)context.getPagePath(), (Path)context.getAssetsDir().resolve(trickId.method_12836()).resolve(trickId.method_12832() + "-mana-cost.png"), (int)500, (int)2).withClass("embedded-component"), mod.master_bw3.coleus.Components.tooltip((List)component.childById(Component.class, "cost-texture").tooltip(), (Path)context.getPagePath(), (Path)context.getAssetsDir().resolve(trickId.method_12836()).resolve(trickId.method_12832() + "-mana-cost-tooltip.png"), (int)2).withClass("embedded-component-tooltip")});
        } else {
            TextureComponent component = io.wispforest.owo.ui.component.Components.texture((class_2960)class_2960.method_60654((String)texture), (int)54, (int)183, (int)109, (int)3, (int)512, (int)256).blend(true);
            manaCostContainer.with((DomContent)mod.master_bw3.coleus.Components.owo((Component)Containers.verticalFlow((Sizing)Sizing.fixed((int)112), (Sizing)Sizing.fixed((int)8)).child((Component)component).padding(Insets.of((int)2, (int)0, (int)0, (int)0)), (Path)context.getPagePath(), (Path)context.getAssetsDir().resolve(trickId.method_12836()).resolve(trickId.method_12832() + "-mana-cost.png"), (int)500, (int)2).withClass("embedded-component"));
        }
        trickContainer.with((DomContent)manaCostContainer);
        return trickContainer;
    }

    public static DomContent spellPreviewTemplate(Map<String, String> properties, PageContext context) {
        if (!properties.containsKey("spell")) {
            return TagCreator.text((String)"");
        }
        String spellString = properties.get("spell");
        String urlEncodedSpellString = URLEncoder.encode(spellString, StandardCharsets.UTF_8);
        return ((DivTag)TagCreator.div().withClass("spell-preview")).with(new DomContent[]{((IframeTag)((IframeTag)TagCreator.iframe().withSrc("https://trickster-studio.maplesyrum.me/viewer/?fixed=false&spell=" + urlEncodedSpellString)).attr("allowtransparency", (Object)"true")).withClass("spell-preview-iframe"), TagCreator.script((DomContent[])new DomContent[]{new UnescapedText("(() => {\n    const currentScript = document.currentScript;\n    const parent = currentScript.parentElement;\n    const iframeElement = parent.querySelector(\".spell-preview-iframe\");\n    const pageElement = document.getElementById(\"page\");\n\n    iframeElement.addEventListener(\"mouseenter\", () => {\n      pageElement.dataset.originalOverflow = pageElement.style.overflow;\n      pageElement.style.overflow = \"hidden\";\n    });\n\n    iframeElement.addEventListener(\"mouseleave\", () => {\n      pageElement.style.overflow = pageElement.dataset.originalOverflow || \"\";\n    });\n})()\n")})});
    }
}

