/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.slf4j.Logger;

public abstract class CompleteJsonDataLoader
extends class_4080<Map<class_2960, List<JsonElement>>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Gson gson;
    private final String dataType;

    public CompleteJsonDataLoader(Gson gson, String dataType) {
        this.gson = gson;
        this.dataType = dataType;
    }

    protected Map<class_2960, List<JsonElement>> prepare(class_3300 resourceManager, class_3695 profiler) {
        HashMap<class_2960, List<JsonElement>> map = new HashMap<class_2960, List<JsonElement>>();
        CompleteJsonDataLoader.load(resourceManager, this.dataType, this.gson, map);
        return map;
    }

    public static void load(class_3300 manager, String dataType, Gson gson, Map<class_2960, List<JsonElement>> results) {
        class_7654 resourceFinder = class_7654.method_45114((String)dataType);
        for (Map.Entry entry : resourceFinder.method_45116(manager).entrySet()) {
            class_2960 key = (class_2960)entry.getKey();
            class_2960 resourceId = resourceFinder.method_45115(key);
            try {
                for (class_3298 resource : (List)entry.getValue()) {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)gson, (Reader)reader, JsonElement.class);
                        results.compute(resourceId, (identifier, jsonElements) -> {
                            List list = Objects.requireNonNullElseGet(jsonElements, ArrayList::new);
                            list.add(jsonElement);
                            return list;
                        });
                    }
                    catch (Throwable exception) {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable e) {
                                exception.addSuppressed(e);
                            }
                        }
                        throw exception;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{resourceId, key, e});
            }
        }
        Map<class_2960, List<JsonElement>> copy = Map.copyOf(results);
        results.clear();
        copy.forEach((identifier, jsonElements) -> results.put((class_2960)identifier, List.copyOf(jsonElements)));
    }
}

