/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.data.CompleteJsonDataLoader;
import dev.enjarai.trickster.mixin.accessor.DataPackContentsAccessor;
import dev.enjarai.trickster.mixin.accessor.TagEntryAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3497;
import net.minecraft.class_3505;
import net.minecraft.class_3695;
import net.minecraft.class_5350;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateToManaConversionLoader
extends CompleteJsonDataLoader
implements IdentifiableResourceReloadListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(StateToManaConversionLoader.class);
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static class_5350 dataPackContents;
    protected final class_7225.class_7874 registryLookup;
    protected ImmutableMap<class_2248, List<ConversionRule>> conversions = ImmutableMap.of();

    public StateToManaConversionLoader(class_7225.class_7874 registryLookup) {
        super(GSON, "conversion/state_to_mana");
        this.registryLookup = registryLookup;
    }

    public class_2960 getFabricId() {
        return Trickster.id("conversion", "state_to_mana");
    }

    protected void apply(Map<class_2960, List<JsonElement>> prepared, class_3300 manager, class_3695 profiler) {
        HashMap<class_2248, List> map = new HashMap<class_2248, List>();
        Optional<Map> perhapsTagMap = ((DataPackContentsAccessor)dataPackContents).getRegistryTagManager().method_40096().stream().filter(registryTags -> registryTags.comp_328().equals(class_7924.field_41254)).map(class_3505.class_6863::comp_329).findFirst();
        if (perhapsTagMap.isEmpty()) {
            throw new IllegalStateException("Failed to get tag data, aborting data loading");
        }
        Map tagMap = perhapsTagMap.get();
        prepared.forEach((identifier, jsonElements) -> {
            for (JsonElement jsonElement : jsonElements) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (!jsonObject.has("target")) {
                    jsonElement.getAsJsonObject().addProperty("target", identifier.toString());
                }
                ConversionData conversionData = (ConversionData)ConversionData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow();
                TagEntryAccessor accessor = (TagEntryAccessor)conversionData.target;
                if (accessor.isTag()) {
                    Optional<Collection> optional = Optional.ofNullable((Collection)tagMap.get(accessor.getId()));
                    if (optional.isPresent()) {
                        for (class_6880 entry : optional.get()) {
                            if (conversionData.replace) {
                                map.put((class_2248)entry.comp_349(), conversionData.rules);
                                continue;
                            }
                            map.merge((class_2248)entry.comp_349(), conversionData.rules, (rules1, rules2) -> {
                                ArrayList concatenatedList = new ArrayList();
                                concatenatedList.addAll(rules1);
                                concatenatedList.addAll(rules2);
                                return concatenatedList;
                            });
                        }
                        continue;
                    }
                    LOGGER.warn("Failed to find tag {}, skipping", (Object)accessor.getId());
                    continue;
                }
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(accessor.getId());
                if (conversionData.replace) {
                    map.put(block, conversionData.rules);
                    continue;
                }
                map.merge(block, conversionData.rules, (rules1, rules2) -> {
                    ArrayList concatenatedList = new ArrayList();
                    concatenatedList.addAll(rules1);
                    concatenatedList.addAll(rules2);
                    return concatenatedList;
                });
            }
        });
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((block, weightedValues) -> builder.put(block, List.copyOf(weightedValues)));
        this.conversions = builder.build();
    }

    public Optional<Float> convert(class_2680 state) {
        List rules = (List)this.conversions.get((Object)state.method_26204());
        if (rules == null) {
            return Optional.empty();
        }
        block0: for (ConversionRule rule : rules) {
            for (class_2769.class_4933<?> property : rule.properties()) {
                if (state.method_11654(property.comp_70()).equals(property.comp_71())) continue;
                continue block0;
            }
            return Optional.of(Float.valueOf(rule.mana()));
        }
        return Optional.empty();
    }

    public record ConversionRule(Collection<class_2769.class_4933<?>> properties, float mana) {
        public static final Function<class_2248, Codec<ConversionRule>> CODEC = class_156.method_34866(block -> {
            Collection properties = block.method_9564().method_28501();
            HashMap<String, Codec> propertyCodecs = HashMap.newHashMap(properties.size());
            for (class_2769 property : properties) {
                propertyCodecs.put(property.method_11899(), property.method_30044());
            }
            Codec propertyNamePropertyCodec = Codec.dispatchedMap((Codec)Codec.STRING, propertyCodecs::get);
            Codec propertyCodec = propertyNamePropertyCodec.xmap(Map::values, values -> {
                HashMap<String, class_2769.class_4933> map = HashMap.newHashMap(values.size());
                for (class_2769.class_4933 value : values) {
                    map.put(value.comp_70().method_11899(), value);
                }
                return map;
            });
            return RecordCodecBuilder.create(instance -> instance.group((App)propertyCodec.optionalFieldOf("properties", List.of()).forGetter(ConversionRule::properties), (App)Codec.FLOAT.fieldOf("mana").forGetter(ConversionRule::mana)).apply((Applicative)instance, ConversionRule::new));
        });
    }

    public record ConversionData(boolean replace, class_3497 target, class_2248 reference, List<ConversionRule> rules) {
        public static final MapDecoder<ConversionData> CODEC_DECODER = new MapDecoder.Implementation<ConversionData>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(ops.createString("target"), ops.createString("block"), ops.createString("rules"));
            }

            public <T> DataResult<ConversionData> decode(DynamicOps<T> ops, MapLike<T> input) {
                class_3497 target;
                Object replaceOp = input.get("replace");
                boolean replace = false;
                if (replaceOp != null) {
                    replace = (Boolean)Codec.BOOL.parse(ops, input.get("replace")).getOrThrow();
                }
                class_2960 block = ((TagEntryAccessor)(target = (class_3497)class_3497.field_39265.parse(ops, input.get("target")).getOrThrow())).isTag() ? (class_2960)class_2960.field_25139.parse(ops, input.get("block")).getOrThrow() : ((TagEntryAccessor)target).getId();
                class_2248 reference = (class_2248)class_7923.field_41175.method_10223(block);
                List rules = (List)ConversionRule.CODEC.apply(reference).listOf().parse(ops, input.get("rules")).getOrThrow();
                return DataResult.success((Object)new ConversionData(replace, target, reference, rules));
            }
        };
        public static final MapEncoder<ConversionData> CODEC_ENCODER = new MapEncoder.Implementation<ConversionData>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(ops.createString("target"), ops.createString("block"), ops.createString("rules"));
            }

            public <T> RecordBuilder<T> encode(ConversionData input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                class_2960 block = class_7923.field_41175.method_10221((Object)input.reference);
                prefix.add("replace", Codec.BOOL.encodeStart(ops, (Object)input.replace));
                prefix.add("target", class_3497.field_39265.encodeStart(ops, (Object)input.target));
                if (((TagEntryAccessor)input.target).isTag()) {
                    prefix.add("block", class_2960.field_25139.encodeStart(ops, (Object)block));
                }
                prefix.add("rules", ConversionRule.CODEC.apply(input.reference).listOf().encodeStart(ops, input.rules));
                return prefix;
            }
        };
        public static final Codec<ConversionData> CODEC = Codec.of(CODEC_ENCODER, CODEC_DECODER).codec();
    }
}

