/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.datagen.provider;

import com.google.common.collect.Maps;
import dev.enjarai.trickster.data.StateToManaConversionLoader;
import dev.enjarai.trickster.mixin.accessor.TagEntryAccessor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public abstract class StateToManaConversionProvider
implements class_2405 {
    protected final class_7784.class_7489 pathResolver;
    private final CompletableFuture<class_7225.class_7874> registryLookupFuture;
    private final Map<class_3497, Builder> builders = Maps.newLinkedHashMap();

    public StateToManaConversionProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookupFuture) {
        this.pathResolver = output.method_45973(class_7784.class_7490.field_39367, "conversion/state_to_mana");
        this.registryLookupFuture = registryLookupFuture;
    }

    protected abstract void configure(class_7225.class_7874 var1);

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.getRegistryLookupFuture().thenCompose(wrapperLookup -> CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(entry -> {
            TagEntryAccessor accessor = (TagEntryAccessor)entry.getKey();
            class_2960 identifier = accessor.isTag() ? accessor.getId().method_45138("tags/") : accessor.getId();
            Path path = this.pathResolver.method_44107(identifier);
            return class_2405.method_53496((class_7403)writer, (class_7225.class_7874)wrapperLookup, StateToManaConversionLoader.ConversionData.CODEC, (Object)((Builder)entry.getValue()).build(), (Path)path);
        }).toArray(CompletableFuture[]::new)));
    }

    protected CompletableFuture<class_7225.class_7874> getRegistryLookupFuture() {
        return this.registryLookupFuture.thenApply(lookup -> {
            this.builders.clear();
            this.configure((class_7225.class_7874)lookup);
            return lookup;
        });
    }

    protected Builder getOrCreateConversion(class_2248 block) {
        class_3497 tagEntry = class_3497.method_43937((class_2960)class_7923.field_41175.method_10221((Object)block));
        return this.builders.computeIfAbsent(tagEntry, identifier -> Builder.create(tagEntry, block));
    }

    protected Builder getOrCreateConversion(class_6862<class_2248> tag, class_2248 reference) {
        class_3497 tagEntry = class_3497.method_43945((class_2960)tag.comp_327());
        return this.builders.computeIfAbsent(tagEntry, identifier -> Builder.create(tagEntry, reference));
    }

    public String method_10321() {
        return "State to Mana Conversion";
    }

    public static class Builder {
        private final class_3497 tag;
        private final class_2248 block;
        private final List<StateToManaConversionLoader.ConversionRule> entries = new ArrayList<StateToManaConversionLoader.ConversionRule>();

        public Builder(class_3497 tag, class_2248 block) {
            this.tag = tag;
            this.block = block;
        }

        public static Builder create(class_3497 tag, class_2248 reference) {
            return new Builder(tag, reference);
        }

        public StateToManaConversionLoader.ConversionData build() {
            return new StateToManaConversionLoader.ConversionData(false, this.tag, this.block, List.copyOf(this.entries));
        }

        public Builder add(float mana, class_2769.class_4933<?> ... properties) {
            this.entries.add(new StateToManaConversionLoader.ConversionRule(List.of(properties), mana));
            return this;
        }
    }
}

