/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.cca.BarsComponent;
import dev.enjarai.trickster.cca.ModEntityComponents;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Comparator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class BarsRenderer {
    public static final class_2960 BAR_TEXTURE = Trickster.id("bar/bar");
    public static final class_2960 BAR_BACKGROUND_TEXTURE = Trickster.id("bar/bar_background");
    private static final class_5819 colorsRandom = new class_6575(762133L);

    public static void render(class_332 context, class_9779 tickCounter) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            BarsComponent barsComponent = (BarsComponent)player.getComponent(ModEntityComponents.BARS);
            Int2ObjectMap<BarsComponent.Bar> bars = barsComponent.getBars();
            context.method_51448().method_22903();
            if (Trickster.CONFIG.barsHorizontal()) {
                context.method_51448().method_46416((float)(context.method_51421() - 64), (float)context.method_51443(), 0.0f);
                context.method_51448().method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                context.method_51448().method_46416((float)(-context.method_51421()), (float)(-context.method_51443()), 0.0f);
            }
            int i = 0;
            for (Int2ObjectMap.Entry entry : bars.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).toList()) {
                BarsRenderer.drawBar(context, i, entry.getIntKey(), 1.0, BAR_BACKGROUND_TEXTURE);
                BarsRenderer.drawBar(context, i, entry.getIntKey(), ((BarsComponent.Bar)entry.getValue()).fill, BAR_TEXTURE);
                ++i;
            }
            context.method_51448().method_22909();
        }
    }

    private static void drawBar(class_332 context, int index, int id, double fill, class_2960 texture) {
        class_1058 sprite = class_310.method_1551().method_52699().method_18667(texture);
        int xOffset = index * 8;
        fill = Math.clamp(fill, 0.0, 1.0);
        colorsRandom.method_43052((long)id);
        BarsRenderer.drawTexturedQuad(context, sprite.method_45852(), context.method_51421() - 2 - 5 - xOffset, context.method_51421() - 2 - xOffset, context.method_51443() - 2 - (int)(61.0 * fill), context.method_51443() - 2, 0, sprite.method_4580(0.0f), sprite.method_4580(1.0f), sprite.method_4570((float)((int)((1.0 - fill) * 61.0)) / 61.0f), sprite.method_4570(1.0f), colorsRandom.method_43057(), colorsRandom.method_43057(), colorsRandom.method_43057(), 1.0f);
    }

    private static void drawTexturedQuad(class_332 context, class_2960 texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_22913(u1, v1).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)z).method_22913(u1, v2).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)z).method_22913(u2, v2).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)z).method_22913(u2, v1).method_22915(red, green, blue, alpha);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }
}

