/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.render;

import dev.enjarai.trickster.ClientUtils;
import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.item.component.ManaComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.spell.mana.ManaPool;
import dev.enjarai.trickster.spell.mana.SharedManaPool;
import dev.enjarai.trickster.util.ImGoingToStabWhoeverInventedTime;
import dev.enjarai.trickster.util.Unit;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class MerlinKeeperTracker
implements Trickster.TooltipAppender {
    private final Int2ObjectMap<MerlinUsage> stackMap = new Int2ObjectOpenHashMap();
    private final int tickSpan;

    public MerlinKeeperTracker(int tickSpan) {
        this.tickSpan = tickSpan;
    }

    public void tick(class_310 client) {
        if (client.field_1724 != null && client.field_1724.field_6012 % this.tickSpan == 0) {
            class_1661 inventory = client.field_1724.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                Object object = stack.method_57824(ModComponents.MANA);
                if (!(object instanceof ManaComponent)) continue;
                ManaComponent component = (ManaComponent)object;
                MerlinUsage usage = (MerlinUsage)this.stackMap.computeIfAbsent(i, j -> new MerlinUsage(component.pool().get((class_1937)client.field_1687)));
                usage.update(component.pool().get((class_1937)client.field_1687));
            }
            this.stackMap.keySet().removeIf(j -> !inventory.method_5438(j).method_57826(ModComponents.MANA));
        }
    }

    public float getUsage(class_1799 stack) {
        if (class_310.method_1551().field_1724 != null) {
            class_1661 inventory = class_310.method_1551().field_1724.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                Object object;
                class_1799 searchStack = inventory.method_5438(i);
                if (searchStack != stack || !((object = this.stackMap.get(i)) instanceof MerlinUsage)) continue;
                MerlinUsage usage = (MerlinUsage)object;
                return usage.getUsage();
            }
        }
        return 0.0f;
    }

    @Override
    public void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_638 world = class_310.method_1551().field_1687;
        float usage = this.getUsage(stack);
        if (usage == 0.0f) {
            tooltip.add((class_2561)class_2561.method_43471((String)"trickster.merlin.idling").method_27694(s -> s.method_36139(0xAAAABB)));
        } else {
            Unit.Merlin usageUnit = Unit.getMerlinUnit(usage);
            tooltip.add((class_2561)(usage > 0.0f ? class_2561.method_43469((String)"trickster.merlin.draining", (Object[])new Object[]{"%.2f ".formatted(Float.valueOf(usageUnit.correct(usage))) + usageUnit.shortName()}) : class_2561.method_43469((String)"trickster.merlin.filling", (Object[])new Object[]{"%.2f ".formatted(Float.valueOf(usageUnit.correct(-usage))) + usageUnit.shortName()})).method_27694(s -> s.method_36139(0xAAAABB)));
        }
        Object object = stack.method_57824(ModComponents.MANA);
        if (object instanceof ManaComponent) {
            ManaComponent component = (ManaComponent)object;
            if (world != null) {
                ManaPool pool = component.pool();
                ClientUtils.trySubscribe(component);
                if (usage != 0.0f) {
                    String str;
                    long timeUntilDrained = (long)(pool.get((class_1937)world) / usage * 50.0f);
                    String string = str = timeUntilDrained >= 0L ? "Time until drained: %s" : "Time until charged: %s";
                    if (timeUntilDrained < 0L) {
                        timeUntilDrained = (long)((pool.get((class_1937)world) - pool.getMax((class_1937)world)) / usage) * 50L;
                    }
                    tooltip.add((class_2561)class_2561.method_43470((String)str.formatted(ImGoingToStabWhoeverInventedTime.howLongIsThisQuestionMark(timeUntilDrained))).method_27694(s -> s.method_36139(0xAAAABB)));
                }
                float current = pool.get((class_1937)world);
                float max = pool.getMax((class_1937)world);
                Unit.Gandalf currentUnit = Unit.getGandalfUnit(current);
                Unit.Gandalf maxUnit = Unit.getGandalfUnit(max);
                tooltip.add((class_2561)class_2561.method_43469((String)"trickster.gandalf.stored", (Object[])new Object[]{("%.1f " + currentUnit.shortName() + " / %.1f " + maxUnit.shortName()).formatted(Float.valueOf(currentUnit.correct(current)), Float.valueOf(maxUnit.correct(max)))}).method_27694(s -> s.method_36139(0xAAAABB)));
                if (pool instanceof SharedManaPool) {
                    SharedManaPool shared = (SharedManaPool)pool;
                    if (class_310.method_1551().field_1687 != null) {
                        tooltip.add((class_2561)class_2561.method_43470((String)shared.uuid().toString()).method_10862(class_2583.field_24360.method_27706(class_124.field_1076)));
                    }
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class MerlinUsage {
        public float prevLastMerlins;
        public float lastMerlins;
        public float latestMerlins;

        public MerlinUsage(float latest) {
            this.prevLastMerlins = latest;
            this.lastMerlins = latest;
            this.latestMerlins = latest;
        }

        public void update(float newMerlins) {
            this.prevLastMerlins = this.lastMerlins;
            this.lastMerlins = this.latestMerlins;
            this.latestMerlins = newMerlins;
        }

        public float getUsage() {
            if (class_310.method_1551().field_1724 == null) {
                return 0.0f;
            }
            return class_3532.method_16439((float)((float)(class_310.method_1551().field_1724.field_6012 % MerlinKeeperTracker.this.tickSpan) / (float)MerlinKeeperTracker.this.tickSpan), (float)(this.prevLastMerlins - this.lastMerlins), (float)(this.lastMerlins - this.latestMerlins)) / (float)MerlinKeeperTracker.this.tickSpan;
        }
    }
}

