/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.render.fragment.FragmentRenderer;
import dev.enjarai.trickster.screen.SpellPartWidget;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.PatternGlyph;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import io.wispforest.owo.ui.core.Color;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.SequencedMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;

@Environment(value=EnvType.CLIENT)
public class SpellCircleRenderer {
    public static final class_2960 CIRCLE_TEXTURE = Trickster.id("textures/gui/circle_48.png");
    public static final class_2960 CIRCLE_TEXTURE_HALF = Trickster.id("textures/gui/circle_24.png");
    public static final float PATTERN_TO_PART_RATIO = 2.5f;
    public static final int PART_PIXEL_RADIUS = 24;
    public static final int CLICK_HITBOX_SIZE = 5;
    public static final class_1921 CIRCLE_TEXTURE_LAYER = class_1921.method_23580((class_2960)CIRCLE_TEXTURE);
    public static final class_1921 GLYPH_LAYER = class_1921.method_24048((String)"trickster:glyph", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27382, (int)786432, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_44817).method_23615(class_4668.field_21370).method_23604(class_4668.field_21348).method_23603(class_4668.field_21345).method_23617(false));
    public static final class_4597.class_4598 VERTEX_CONSUMERS = class_4597.method_22992((SequencedMap)((SequencedMap)class_156.method_654((Object)new Object2ObjectLinkedOpenHashMap(), map -> {
        map.put((Object)CIRCLE_TEXTURE_LAYER, (Object)new class_9799(CIRCLE_TEXTURE_LAYER.method_22722()));
        map.put((Object)GLYPH_LAYER, (Object)new class_9799(GLYPH_LAYER.method_22722()));
    })), (class_9799)new class_9799(2048));
    public final boolean inUI;
    private final boolean inEditor;
    private final double precisionOffset;
    public final boolean animated;
    private Supplier<SpellPart> drawingPartGetter;
    private Supplier<List<Byte>> drawingPatternGetter;
    private double mouseX;
    private double mouseY;
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float circleTransparency = 1.0f;
    private static final class_5819 glyphRandom = new class_6575(0L);

    public SpellCircleRenderer(Boolean inUI, double precisionOffset) {
        this.inUI = inUI;
        this.inEditor = false;
        this.precisionOffset = precisionOffset;
        this.animated = true;
    }

    public SpellCircleRenderer(Supplier<SpellPart> drawingPartGetter, Supplier<List<Byte>> drawingPatternGetter, double precisionOffset, boolean animated) {
        this.drawingPartGetter = drawingPartGetter;
        this.drawingPatternGetter = drawingPatternGetter;
        this.animated = animated;
        this.inUI = true;
        this.inEditor = true;
        this.precisionOffset = precisionOffset;
    }

    public void setMousePosition(double mouseX, double mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    public void setColor(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public boolean isInEditor() {
        return this.inEditor;
    }

    public double getMouseX() {
        return this.mouseX;
    }

    public double getMouseY() {
        return this.mouseY;
    }

    public void setCircleTransparency(float circleTransparency) {
        this.circleTransparency = circleTransparency;
    }

    public float getCircleTransparency() {
        return this.circleTransparency;
    }

    private float toLocalSpace(double value) {
        return (float)(value * this.precisionOffset);
    }

    public void renderPart(class_4587 matrices, class_4597 vertexConsumers, SpellPart entry, double x, double y, double radius, double startingAngle, float delta, Function<Float, Float> alphaGetter, class_243 normal) {
        this.renderPartWithoutDrawing(matrices, vertexConsumers, entry, x, y, radius, startingAngle, delta, alphaGetter, normal);
        VERTEX_CONSUMERS.method_22993();
    }

    public void renderPartWithoutDrawing(class_4587 matrices, class_4597 vertexConsumers, SpellPart entry, double x, double y, double radius, double startingAngle, float delta, Function<Float, Float> alphaGetter, class_243 normal) {
        this.renderPartInner(matrices, (class_4597)VERTEX_CONSUMERS, entry, x, y, radius, startingAngle, delta, alphaGetter, normal);
    }

    private void renderPartInner(class_4587 matrices, class_4597 vertexConsumers, SpellPart entry, double x, double y, double radius, double startingAngle, float delta, Function<Float, Float> alphaGetter, class_243 normal) {
        Float alpha = alphaGetter.apply(Float.valueOf(this.toLocalSpace(radius)));
        SpellCircleRenderer.drawTexturedQuad(matrices, vertexConsumers, CIRCLE_TEXTURE, this.toLocalSpace(x - radius), this.toLocalSpace(x + radius), this.toLocalSpace(y - radius), this.toLocalSpace(y + radius), 0.0f, this.r, this.g, this.b, alpha.floatValue() * this.circleTransparency, this.inUI);
        this.drawGlyph(matrices, vertexConsumers, entry, x, y, radius, startingAngle, delta, alphaGetter, normal);
        int partCount = entry.partCount();
        this.drawDivider(matrices, vertexConsumers, this.toLocalSpace(x), this.toLocalSpace(y), startingAngle, this.toLocalSpace(radius), partCount, alpha.floatValue());
        if (!this.inUI && radius < (double)0.01f) {
            return;
        }
        matrices.method_22903();
        if (!this.inUI) {
            matrices.method_22904(0.0, 0.0, -radius / 8.0);
        }
        int i = 0;
        for (SpellPart child : entry.getSubParts()) {
            double angle = entry.subAngle(i, startingAngle);
            double subX = x + radius * Math.cos(angle);
            double subY = y + radius * Math.sin(angle);
            this.renderPartInner(matrices, vertexConsumers, child, subX, subY, entry.subRadius(radius), angle, delta, alphaGetter, normal);
            ++i;
        }
        matrices.method_22909();
    }

    protected void drawDivider(class_4587 matrices, class_4597 vertexConsumers, float x, float y, double startingAngle, float radius, float partCount, float alpha) {
        float pixelSize = radius / 24.0f;
        double lineAngle = startingAngle + Math.PI * 2 / (double)partCount * -0.5 - 1.5707963267948966;
        float lineX = (float)((double)x + (double)radius * Math.cos(lineAngle));
        float lineY = (float)((double)y + (double)radius * Math.sin(lineAngle));
        Vector2f toCenterVec = new Vector2f(lineX - x, lineY - y).normalize();
        Vector2f perpendicularVec = new Vector2f((Vector2fc)toCenterVec).perpendicular();
        toCenterVec.mul(pixelSize * 6.0f);
        perpendicularVec.mul(pixelSize * 0.5f);
        Color dividerColor = Trickster.CONFIG.subcircleDividerPinColor();
        SpellCircleRenderer.drawFlatPolygon(matrices, vertexConsumers, lineX - perpendicularVec.x + toCenterVec.x * 0.5f, lineY - perpendicularVec.y + toCenterVec.y * 0.5f, lineX + perpendicularVec.x + toCenterVec.x * 0.5f, lineY + perpendicularVec.y + toCenterVec.y * 0.5f, lineX + perpendicularVec.x - toCenterVec.x, lineY + perpendicularVec.y - toCenterVec.y, lineX - perpendicularVec.x - toCenterVec.x, lineY - perpendicularVec.y - toCenterVec.y, 0.0f, dividerColor.red() * this.r, dividerColor.green() * this.g, dividerColor.blue() * this.b, dividerColor.alpha() * alpha);
    }

    protected void drawGlyph(class_4587 matrices, class_4597 vertexConsumers, SpellPart parent, double x, double y, double radius, double startingAngle, float delta, Function<Float, Float> alphaGetter, class_243 normal) {
        Fragment glyph = parent.getGlyph();
        if (glyph instanceof SpellPart) {
            SpellPart part = (SpellPart)glyph;
            this.renderPartInner(matrices, vertexConsumers, part, x, y, radius / 3.0, startingAngle, delta, alphaGetter, normal);
        } else {
            matrices.method_22903();
            this.drawSide(matrices, vertexConsumers, parent, this.toLocalSpace(x), this.toLocalSpace(y), this.toLocalSpace(radius), alphaGetter, normal, delta, glyph);
            matrices.method_22909();
        }
    }

    private void drawSide(class_4587 matrices, class_4597 vertexConsumers, SpellPart parent, float x, float y, float radius, Function<Float, Float> alphaGetter, class_243 normal, float delta, Fragment glyph) {
        Float alpha = alphaGetter.apply(Float.valueOf(radius));
        float patternRadius = radius / 2.5f;
        float pixelSize = patternRadius / 24.0f;
        if (glyph instanceof PatternGlyph) {
            PatternGlyph pattern = (PatternGlyph)glyph;
            boolean isDrawing = this.inEditor && this.drawingPartGetter.get() == parent;
            List<Byte> drawingPattern = this.inEditor ? this.drawingPatternGetter.get() : null;
            Pattern patternList = isDrawing ? Pattern.from(drawingPattern) : pattern.pattern();
            for (int i = 0; i < 9; ++i) {
                Vector2f pos = SpellCircleRenderer.getPatternDotPosition(x, y, i, patternRadius);
                boolean isLinked = isDrawing ? drawingPattern.contains((byte)i) : patternList.contains(i);
                float dotScale = 1.0f;
                if (this.inEditor && SpellCircleRenderer.isInsideHitbox(pos, pixelSize, this.mouseX, this.mouseY) && SpellPartWidget.isCircleClickable(radius)) {
                    dotScale = 1.6f;
                } else if (!isLinked) {
                    if (!this.inEditor || !SpellPartWidget.isCircleClickable(radius)) continue;
                    float mouseDistance = new Vector2f((float)(this.mouseX - (double)pos.x), (float)(this.mouseY - (double)pos.y)).length();
                    dotScale = Math.clamp(patternRadius / mouseDistance - 0.2f, 0.0f, 1.0f);
                }
                float dotSize = pixelSize * dotScale;
                SpellCircleRenderer.drawFlatPolygon(matrices, vertexConsumers, pos.x - dotSize, pos.y - dotSize, pos.x - dotSize, pos.y + dotSize, pos.x + dotSize, pos.y + dotSize, pos.x + dotSize, pos.y - dotSize, 0.0f, (isDrawing && isLinked ? 0.8f : 1.0f) * this.r, (isDrawing && isLinked ? 0.5f : 1.0f) * this.g, 1.0f * this.b, 0.7f * alpha.floatValue());
            }
            for (Pattern.PatternEntry line : patternList.entries()) {
                Vector2f first = SpellCircleRenderer.getPatternDotPosition(x, y, line.p1(), patternRadius);
                Vector2f second = SpellCircleRenderer.getPatternDotPosition(x, y, line.p2(), patternRadius);
                SpellCircleRenderer.drawGlyphLine(matrices, vertexConsumers, first, second, pixelSize, isDrawing, 1.0f, this.r, this.g, this.b, 0.7f * alpha.floatValue(), this.animated && this.inUI);
            }
            if (this.inEditor && isDrawing) {
                Vector2f last = SpellCircleRenderer.getPatternDotPosition(x, y, drawingPattern.getLast().byteValue(), patternRadius);
                Vector2f now = new Vector2f((float)this.mouseX, (float)this.mouseY);
                SpellCircleRenderer.drawGlyphLine(matrices, vertexConsumers, last, now, pixelSize, true, 1.0f, this.r, this.g, this.b, 0.7f * alpha.floatValue(), this.animated && this.inUI);
            }
        } else {
            FragmentRenderer renderer = (FragmentRenderer)FragmentRenderer.REGISTRY.method_10223(FragmentType.REGISTRY.method_10221(glyph.type()));
            boolean renderDots = true;
            if (renderer != null) {
                renderer.render(glyph, matrices, vertexConsumers, x, y, radius, alpha.floatValue(), normal, delta, this);
                renderDots = renderer.renderRedrawDots();
            } else {
                FragmentRenderer.renderAsText(glyph, matrices, vertexConsumers, x, y, radius, alpha.floatValue());
            }
            if (this.inEditor && this.inUI && renderDots) {
                for (int i = 0; i < 9; ++i) {
                    float dotScale;
                    Vector2f pos = SpellCircleRenderer.getPatternDotPosition(x, y, i, patternRadius);
                    if (SpellCircleRenderer.isInsideHitbox(pos, pixelSize, this.mouseX, this.mouseY) && SpellPartWidget.isCircleClickable(radius)) {
                        dotScale = 1.6f;
                    } else {
                        if (!SpellPartWidget.isCircleClickable(radius)) continue;
                        float mouseDistance = new Vector2f((float)(this.mouseX - (double)pos.x), (float)(this.mouseY - (double)pos.y)).length();
                        dotScale = Math.clamp(patternRadius / (mouseDistance * 2.0f) - 0.2f, 0.0f, 1.0f);
                    }
                    float dotSize = pixelSize * dotScale;
                    SpellCircleRenderer.drawFlatPolygon(matrices, vertexConsumers, pos.x - dotSize, pos.y - dotSize, pos.x - dotSize, pos.y + dotSize, pos.x + dotSize, pos.y + dotSize, pos.x + dotSize, pos.y - dotSize, 0.0f, this.r, this.g, this.b, 0.25f);
                }
            }
        }
    }

    public static void drawGlyphLine(class_4587 matrices, class_4597 vertexConsumers, Vector2f last, Vector2f now, float pixelSize, boolean isDrawing, float tone, float r, float g, float b, float opacity, boolean animated) {
        if (last.distance((Vector2fc)now) < pixelSize * 6.0f) {
            return;
        }
        Vector2f parallelVec = new Vector2f(last.y - now.y, now.x - last.x).normalize().mul(pixelSize / 2.0f);
        Vector2f directionVec = new Vector2f(last.x - now.x, last.y - now.y).normalize().mul(pixelSize * 3.0f);
        if (animated) {
            Vector2f lineStart = new Vector2f(last.x - directionVec.x, last.y - directionVec.y);
            Vector2f lineEnd = new Vector2f(now.x + directionVec.x, now.y + directionVec.y);
            Vector2f parallel1 = parallelVec.mul(1.0f + glyphRandom.method_43057() - 0.5f, new Vector2f());
            Vector2f parallel2 = new Vector2f();
            float steps = last.distance((Vector2fc)now) / pixelSize / 4.0f;
            int i = 0;
            while ((float)i < steps) {
                float lineLength = Math.min(1.0f, steps - (float)i);
                Vector2f pos1 = lineStart.lerp((Vector2fc)lineEnd, (float)i / steps, new Vector2f());
                Vector2f pos2 = lineStart.lerp((Vector2fc)lineEnd, ((float)i + lineLength) / steps, new Vector2f());
                parallel2 = parallelVec.mul(1.0f + (glyphRandom.method_43057() - 0.5f) * lineLength, parallel2);
                Vector2f finalParallel1 = parallel1;
                Vector2f finalParallel2 = parallel2;
                SpellCircleRenderer.drawFlatPolygon(matrices, vertexConsumers, pos1.x - finalParallel1.x, pos1.y - finalParallel1.y, pos1.x + finalParallel1.x, pos1.y + finalParallel1.y, pos2.x + finalParallel2.x, pos2.y + finalParallel2.y, pos2.x - finalParallel2.x, pos2.y - finalParallel2.y, 0.0f, (isDrawing ? 0.8f : tone) * r, (isDrawing ? 0.5f : tone) * g, 1.0f * b, opacity);
                parallel1 = parallel1.set((Vector2fc)parallel2);
                ++i;
            }
        } else {
            SpellCircleRenderer.drawFlatPolygon(matrices, vertexConsumers, last.x - parallelVec.x - directionVec.x, last.y - parallelVec.y - directionVec.y, last.x + parallelVec.x - directionVec.x, last.y + parallelVec.y - directionVec.y, now.x + parallelVec.x + directionVec.x, now.y + parallelVec.y + directionVec.y, now.x - parallelVec.x + directionVec.x, now.y - parallelVec.y + directionVec.y, 0.0f, (isDrawing ? 0.5f : tone) * r, (isDrawing ? 0.5f : tone) * g, tone * b, opacity);
        }
    }

    public static Vector2f getPatternDotPosition(float x, float y, int i, float radius) {
        float xSign = i % 3 - 1;
        float ySign = i / 3 - 1;
        if (xSign != 0.0f && ySign != 0.0f) {
            xSign *= 0.7f;
            ySign *= 0.7f;
        }
        return new Vector2f(x + xSign * radius, y + ySign * radius);
    }

    public static boolean isInsideHitbox(Vector2f pos, float pixelSize, double mouseX, double mouseY) {
        float hitboxSize = 5.0f * pixelSize;
        return mouseX >= (double)(pos.x - hitboxSize) && mouseX <= (double)(pos.x + hitboxSize) && mouseY >= (double)(pos.y - hitboxSize) && mouseY <= (double)(pos.y + hitboxSize);
    }

    public static void drawTexturedQuad(class_4587 matrices, class_4597 vertexConsumers, class_2960 texture, float x1, float x2, float y1, float y2, float z, float r, float g, float b, float alpha, boolean inGui) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        class_4587.class_4665 matrixEntry = matrices.method_23760();
        Matrix4f position = matrixEntry.method_23761();
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)texture));
        if (!inGui) {
            vertexConsumer.method_22918(position, x1, y1, z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22915(r, g, b, alpha).method_22914(0.0f, 1.0f, 0.0f);
            vertexConsumer.method_22918(position, x1, y2, z).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22915(r, g, b, alpha).method_22914(0.0f, 1.0f, 0.0f);
            vertexConsumer.method_22918(position, x2, y2, z).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22915(r, g, b, alpha).method_22914(0.0f, 1.0f, 0.0f);
            vertexConsumer.method_22918(position, x2, y1, z).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22915(r, g, b, alpha).method_22914(0.0f, 1.0f, 0.0f);
        } else {
            vertexConsumer.method_22918(position, x1, y1, z).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22915(r, g, b, alpha).method_22914(-1.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(position, x1, y2, z).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22915(r, g, b, alpha).method_22914(-1.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(position, x2, y2, z).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22915(r, g, b, alpha).method_22914(-1.0f, 0.0f, 0.0f);
            vertexConsumer.method_22918(position, x2, y1, z).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22915(r, g, b, alpha).method_22914(-1.0f, 0.0f, 0.0f);
        }
    }

    public static void drawFlatPolygon(class_4587 matrices, class_4597 vertexConsumers, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float z, float r, float g, float b, float alpha) {
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        class_4588 vertexConsumer = vertexConsumers.getBuffer(GLYPH_LAYER);
        vertexConsumer.method_22918(matrix4f, x1, y1, z).method_22915(r, g, b, alpha);
        vertexConsumer.method_22918(matrix4f, x2, y2, z).method_22915(r, g, b, alpha);
        vertexConsumer.method_22918(matrix4f, x3, y3, z).method_22915(r, g, b, alpha);
        vertexConsumer.method_22918(matrix4f, x4, y4, z).method_22915(r, g, b, alpha);
    }
}

