/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.render.fragment;

import dev.enjarai.trickster.render.SpellCircleRenderer;
import dev.enjarai.trickster.render.fragment.FragmentRenderer;
import dev.enjarai.trickster.screen.SpellPartWidget;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.PatternGlyph;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.joml.Vector2f;

@Environment(value=EnvType.CLIENT)
public class PatternRenderer
implements FragmentRenderer<PatternGlyph> {
    @Override
    public void render(PatternGlyph fragment, class_4587 matrices, class_4597 vertexConsumers, float x, float y, float size, float alpha, class_243 normal, float tickDelta, SpellCircleRenderer delegator) {
        PatternRenderer.renderPattern(fragment.pattern(), matrices, vertexConsumers, x, y, size / 2.5f, alpha, delegator);
    }

    public static void renderPattern(Pattern pattern, class_4587 matrices, class_4597 vertexConsumers, float x, float y, float size, float alpha, SpellCircleRenderer delegator) {
        float pixelSize = size / 24.0f;
        float r = delegator.getR();
        float g = delegator.getG();
        float b = delegator.getB();
        for (int i = 0; i < 9; ++i) {
            Vector2f pos = SpellCircleRenderer.getPatternDotPosition(x, y, i, size);
            boolean isLinked = pattern.contains(i);
            float dotScale = 1.0f;
            if (delegator.isInEditor() && SpellCircleRenderer.isInsideHitbox(pos, pixelSize, delegator.getMouseX(), delegator.getMouseY()) && SpellPartWidget.isCircleClickable(size)) {
                dotScale = 1.6f;
            } else if (!isLinked) {
                if (!delegator.isInEditor() || !SpellPartWidget.isCircleClickable(size)) continue;
                float mouseDistance = new Vector2f((float)(delegator.getMouseX() - (double)pos.x), (float)(delegator.getMouseY() - (double)pos.y)).length();
                dotScale = Math.clamp(size / mouseDistance - 0.2f, 0.0f, 1.0f);
            }
            float dotSize = pixelSize * dotScale;
            SpellCircleRenderer.drawFlatPolygon(matrices, vertexConsumers, pos.x - dotSize, pos.y - dotSize, pos.x - dotSize, pos.y + dotSize, pos.x + dotSize, pos.y + dotSize, pos.x + dotSize, pos.y - dotSize, 0.0f, r, g, b, 0.7f * alpha);
        }
        for (Pattern.PatternEntry line : pattern.entries()) {
            Vector2f first = SpellCircleRenderer.getPatternDotPosition(x, y, line.p1(), size);
            Vector2f second = SpellCircleRenderer.getPatternDotPosition(x, y, line.p2(), size);
            SpellCircleRenderer.drawGlyphLine(matrices, vertexConsumers, first, second, pixelSize, false, 1.0f, r, g, b, 0.7f * alpha, delegator.animated);
        }
    }

    @Override
    public boolean renderRedrawDots() {
        return false;
    }
}

