/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.revision;

import dev.enjarai.trickster.revision.Revision;
import dev.enjarai.trickster.revision.RevisionContext;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class WriteAddressToOffHandRevision
implements Revision {
    @Override
    public Pattern pattern() {
        return Pattern.of(1, 0, 4, 8, 7, 6, 4, 2, 1, 4);
    }

    @Override
    public SpellPart apply(RevisionContext ctx, SpellPart root, SpellPart drawingPart) {
        Optional<List<Integer>> address = WriteAddressToOffHandRevision.getAddress(root, drawingPart);
        if (address.isPresent()) {
            ListFragment addressFragment = new ListFragment(address.get().stream().map(num -> new NumberFragment(num.intValue())).toList());
            ctx.updateOffHandSpell(new SpellPart(addressFragment, List.of()));
        }
        return root;
    }

    private static Optional<List<Integer>> getAddress(SpellPart node, SpellPart target) {
        LinkedList<Integer> address = new LinkedList<Integer>();
        boolean found = WriteAddressToOffHandRevision.getAddress(node, target, address, new LinkedList<SpellPart>());
        if (found) {
            return Optional.of(address);
        }
        return Optional.empty();
    }

    private static boolean getAddress(SpellPart node, SpellPart target, List<Integer> address, List<SpellPart> glyphSpells) {
        if (node == target) {
            return true;
        }
        Fragment fragment = node.glyph;
        if (fragment instanceof SpellPart) {
            SpellPart glyph = (SpellPart)fragment;
            glyphSpells.add(glyph);
        }
        List<SpellPart> subParts = node.subParts;
        for (int i = 0; i < subParts.size(); ++i) {
            address.add(i);
            boolean found = WriteAddressToOffHandRevision.getAddress(subParts.get(i), target, address, glyphSpells);
            if (found) {
                return true;
            }
            address.removeLast();
        }
        if (address.isEmpty()) {
            for (SpellPart glyph : glyphSpells) {
                boolean found = WriteAddressToOffHandRevision.getAddress(glyph, target, address, new LinkedList<SpellPart>());
                if (!found) continue;
                return true;
            }
        }
        return false;
    }
}

