/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.screen.owo;

import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.render.SpellCircleRenderer;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.trick.Tricks;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4597;
import org.joml.Vector2f;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class GlyphComponent
extends BaseComponent {
    protected Pattern pattern;
    protected List<Integer> patternList;
    protected int size;

    public GlyphComponent(Trick<?> trick, int size) {
        this(trick.getPattern(), size);
    }

    public GlyphComponent(Pattern pattern, int size) {
        this.pattern = pattern;
        this.size = size;
        this.patternList = pattern.entries().stream().flatMapToInt(e -> IntStream.of(e.p1(), e.p2())).distinct().boxed().toList();
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        int patternSize = this.size / 2;
        boolean[] dotTerminalStatus = this.pattern.dotTerminalStatus();
        for (int i = 0; i < 9; ++i) {
            Vector2f pos = SpellCircleRenderer.getPatternDotPosition(this.x + patternSize + 4, this.y + patternSize + 4, i, patternSize);
            boolean isLinked = this.patternList.contains(i);
            boolean dotSize = true;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (dotTerminalStatus[i] && Trickster.CONFIG.dotEmphasis()) {
                r = Trickster.CONFIG.dotEmphasisColor().red();
                g = Trickster.CONFIG.dotEmphasisColor().green();
                b = Trickster.CONFIG.dotEmphasisColor().blue();
            }
            SpellCircleRenderer.drawFlatPolygon(context.method_51448(), (class_4597)context.method_51450(), pos.x - (float)dotSize, pos.y - (float)dotSize, pos.x - (float)dotSize, pos.y + (float)dotSize, pos.x + (float)dotSize, pos.y + (float)dotSize, pos.x + (float)dotSize, pos.y - (float)dotSize, 0.0f, r, g, b, isLinked ? 0.9f : 0.5f);
        }
        for (Pattern.PatternEntry line : this.pattern.entries()) {
            Vector2f now = SpellCircleRenderer.getPatternDotPosition(this.x + patternSize + 4, this.y + patternSize + 4, line.p1(), patternSize);
            Vector2f last = SpellCircleRenderer.getPatternDotPosition(this.x + patternSize + 4, this.y + patternSize + 4, line.p2(), patternSize);
            SpellCircleRenderer.drawGlyphLine(context.method_51448(), (class_4597)context.method_51450(), last, now, 1.0f, false, 0.0f, 1.0f, 1.0f, 1.0f, 0.9f, false);
        }
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.size + 8;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        return this.size + 8;
    }

    public static GlyphComponent parseTrick(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"trick-id"});
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"size"});
        class_2960 trickId = UIParsing.parseIdentifier((Node)element.getAttributeNode("trick-id"));
        Trick trick = (Trick)Tricks.REGISTRY.method_10223(trickId);
        if (trick == null) {
            throw new UIModelParsingException("Not a valid trick: " + String.valueOf(trickId));
        }
        int size = UIParsing.parseUnsignedInt((Node)element.getAttributeNode("size"));
        return new GlyphComponent(trick, size);
    }

    public static GlyphComponent parseList(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"pattern"});
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"size"});
        String patternString = element.getAttributeNode("pattern").getTextContent();
        Pattern pattern = Pattern.from(Arrays.stream(patternString.split(",")).map(s -> Byte.valueOf(s, 10)).toList());
        int size = UIParsing.parseUnsignedInt((Node)element.getAttributeNode("size"));
        return new GlyphComponent(pattern, size);
    }
}

