/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.screen.owo;

import dev.enjarai.trickster.screen.owo.GlyphComponent;
import dev.enjarai.trickster.screen.owo.ManaCostComponent;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.trick.Tricks;
import dev.enjarai.trickster.spell.type.Signature;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import java.util.Arrays;
import java.util.Iterator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Environment(value=EnvType.CLIENT)
public class TrickOverviewComponent
extends FlowLayout {
    public static TrickOverviewComponent of(Trick<?> trick, @Nullable String costCalculation, class_2960 bookTexture) {
        Pattern pattern = trick.getPattern();
        class_5250 name = class_2561.method_43473();
        trick.getName().method_10855().forEach(s -> name.method_10852((class_2561)s.method_27661().method_27692(class_124.field_1063)));
        class_5250 signatures = class_2561.method_43473();
        Iterator<Signature<?>> iterator = trick.getSignatures().iterator();
        while (iterator.hasNext()) {
            Signature<?> signature = iterator.next();
            signatures = signatures.method_10852((class_2561)signature.asText());
            if (!iterator.hasNext()) continue;
            signatures = signatures.method_27693("\n");
        }
        return new TrickOverviewComponent(pattern, (class_2561)name, signatures, costCalculation, bookTexture);
    }

    public static TrickOverviewComponent of(Pattern pattern, class_2561 title, class_5250 content, @Nullable String costCalculation, class_2960 bookTexture) {
        return new TrickOverviewComponent(pattern, title, content, costCalculation, bookTexture);
    }

    private TrickOverviewComponent(Pattern pattern, class_2561 title, class_5250 content, @Nullable String costCalculation, class_2960 bookTexture) {
        super(Sizing.fill((int)100), Sizing.content(), FlowLayout.Algorithm.VERTICAL);
        this.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        this.child(Components.label((class_2561)title).color(Color.ofFormatting((class_124)class_124.field_1063)).horizontalTextAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)2, (int)2, (int)0, (int)0)).sizing(Sizing.fill((int)100), Sizing.content()));
        this.child((Component)new GlyphComponent(pattern, 50));
        this.child(Components.label((class_2561)content.method_27694(s -> s.method_27706(class_124.field_1063).method_27704(class_310.field_24211))).horizontalTextAlignment(HorizontalAlignment.LEFT).horizontalSizing(Sizing.fill((int)100)).margins(Insets.of((int)0, (int)5, (int)3, (int)3)));
        if (costCalculation != null) {
            this.child((Component)new ManaCostComponent(costCalculation, bookTexture));
        } else {
            this.child((Component)Components.texture((class_2960)bookTexture, (int)54, (int)183, (int)109, (int)3, (int)512, (int)256).blend(true));
        }
        this.allowOverflow(true);
    }

    public static TrickOverviewComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"texture"});
        class_2960 texture = UIParsing.parseIdentifier((Node)element.getAttributeNode("texture"));
        Attr trickIdAttribute = element.getAttributeNode("trick-id");
        if (trickIdAttribute != null) {
            class_2960 trickId = UIParsing.parseIdentifier((Node)element.getAttributeNode("trick-id"));
            Trick trick = (Trick)Tricks.REGISTRY.method_10223(trickId);
            if (trick == null) {
                throw new UIModelParsingException("Not a valid trick: " + String.valueOf(trickId));
            }
            String costCalculation = null;
            if (element.hasAttribute("cost")) {
                costCalculation = element.getAttribute("cost");
            }
            return TrickOverviewComponent.of(trick, costCalculation, texture);
        }
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"pattern", "title"});
        class_5250 title = class_2561.method_43470((String)element.getAttributeNode("title").getTextContent());
        String patternString = element.getAttributeNode("pattern").getTextContent();
        Pattern pattern = Pattern.from(Arrays.stream(patternString.split(",")).map(s -> Byte.valueOf(s, 10)).toList());
        class_5250 content = class_2561.method_43470((String)element.getAttributeNode("content").getTextContent());
        return TrickOverviewComponent.of(pattern, (class_2561)title, content, null, texture);
    }
}

