/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell;

import dev.enjarai.trickster.spell.EvaluationResult;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.IncompatibleTypesBlunder;
import dev.enjarai.trickster.spell.blunder.OverweightFragmentBlunder;
import dev.enjarai.trickster.spell.blunder.UnknownTrickBlunder;
import dev.enjarai.trickster.spell.fragment.AddableFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.SubtractableFragment;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.trick.Tricks;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import org.apache.commons.lang3.ArrayUtils;

public record PatternGlyph(Pattern pattern) implements Fragment,
AddableFragment,
SubtractableFragment
{
    public static final StructEndec<PatternGlyph> ENDEC = StructEndecBuilder.of((StructField)Pattern.ENDEC.fieldOf("pattern", PatternGlyph::pattern), PatternGlyph::new);

    public PatternGlyph() {
        this(Pattern.EMPTY);
    }

    public PatternGlyph(int ... pattern) {
        this(Stream.of(ArrayUtils.toObject((int[])pattern)).map(Integer::byteValue).toList());
    }

    public PatternGlyph(List<Byte> pattern) {
        this(Pattern.from(pattern));
    }

    @Override
    public EvaluationResult activateAsGlyph(SpellContext ctx, List<Fragment> fragments) throws BlunderException {
        Fragment fragment;
        if (this.pattern.equals(Pattern.EMPTY)) {
            return VoidFragment.INSTANCE;
        }
        Trick<?> trick = Tricks.lookup(this.pattern);
        if (trick == null) {
            throw new UnknownTrickBlunder();
        }
        Set<UUID> restricted = trick.restricted();
        if (restricted != null && ctx.source().getPlayer().map(p -> !restricted.contains(p.method_5667())).orElse(true).booleanValue()) {
            throw new UnknownTrickBlunder();
        }
        EvaluationResult result = trick.activate(ctx, fragments);
        if (result instanceof Fragment && (fragment = (Fragment)result).getWeight() > 64000) {
            throw new OverweightFragmentBlunder(trick, fragment);
        }
        return result;
    }

    @Override
    public FragmentType<?> type() {
        return FragmentType.PATTERN;
    }

    @Override
    public class_2561 asText() {
        Trick<?> trick = Tricks.lookup(this.pattern);
        if (trick != null) {
            return trick.getName();
        }
        return class_2561.method_30163((String)"Unknown");
    }

    @Override
    public int getWeight() {
        return this.pattern.getWeight();
    }

    @Override
    public AddableFragment add(Fragment other) throws BlunderException {
        if (other instanceof PatternGlyph) {
            PatternGlyph otherPattern = (PatternGlyph)other;
            return new PatternGlyph(this.pattern().add(otherPattern.pattern()));
        }
        throw new IncompatibleTypesBlunder(Tricks.ADD);
    }

    @Override
    public SubtractableFragment subtract(Fragment other) throws BlunderException {
        if (other instanceof PatternGlyph) {
            PatternGlyph otherPattern = (PatternGlyph)other;
            return new PatternGlyph(this.pattern().subtract(otherPattern.pattern()));
        }
        throw new IncompatibleTypesBlunder(Tricks.SUBTRACT);
    }
}

