/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.execution;

import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.blunder.ExecutionLimitReachedBlunder;
import dev.enjarai.trickster.spell.blunder.NotEnoughManaBlunder;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import dev.enjarai.trickster.spell.trick.Trick;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class ExecutionState {
    public static final int MAX_RECURSION_DEPTH = 255;
    public static final StructEndec<ExecutionState> ENDEC = StructEndecBuilder.of((StructField)Endec.INT.fieldOf("recursions", ExecutionState::getRecursions), (StructField)Endec.INT.fieldOf("delay", ExecutionState::getDelay), (StructField)Endec.BOOLEAN.fieldOf("has_used_mana", ExecutionState::hasUsedMana), (StructField)Endec.INT.fieldOf("stacktrace_size_when_made", ExecutionState::getInitialStacktraceSize), (StructField)Fragment.ENDEC.listOf().fieldOf("arguments", state -> state.arguments), (StructField)Endec.INT.listOf().fieldOf("stacktrace", state -> state.stacktrace.stream().toList()), (StructField)EndecTomfoolery.safeOptionalOf(MutableManaPool.ENDEC).optionalFieldOf("pool_override", state -> state.poolOverride, Optional.empty()), ExecutionState::new);
    private int recursions;
    private int delay;
    private boolean hasUsedMana;
    private final int initialStacktraceSize;
    private final List<Fragment> arguments;
    private final Deque<Integer> stacktrace = new ArrayDeque<Integer>();
    private final Optional<MutableManaPool> poolOverride;

    private ExecutionState(int recursions, int delay, boolean hasUsedMana, int initialStacktraceSize, List<Fragment> arguments, List<Integer> stacktrace, Optional<MutableManaPool> poolOverride) {
        this.recursions = recursions;
        this.delay = delay;
        this.hasUsedMana = hasUsedMana;
        this.initialStacktraceSize = initialStacktraceSize;
        this.arguments = arguments;
        this.stacktrace.addAll(stacktrace);
        this.poolOverride = poolOverride;
    }

    public ExecutionState(List<Fragment> arguments) {
        this(0, 0, false, 0, arguments, List.of(), Optional.empty());
    }

    public ExecutionState(List<Fragment> arguments, MutableManaPool poolOverride) {
        this(0, 0, false, 0, arguments, List.of(), Optional.ofNullable(poolOverride));
    }

    private ExecutionState(int recursions, List<Fragment> arguments, Optional<MutableManaPool> poolOverride, Deque<Integer> stacktrace) {
        this(recursions, 0, false, stacktrace.size(), arguments, stacktrace.stream().toList(), poolOverride);
    }

    public ExecutionState recurseOrThrow(List<Fragment> arguments) throws ExecutionLimitReachedBlunder {
        if (this.recursions + 1 >= 255) {
            throw new ExecutionLimitReachedBlunder();
        }
        ExecutionState state = new ExecutionState(this.recursions + 1, arguments, this.poolOverride, this.stacktrace);
        state.stacktrace.push(-2);
        return state;
    }

    public void decrementRecursions() {
        --this.recursions;
        while (!this.stacktrace.isEmpty() && this.stacktrace.size() >= this.initialStacktraceSize) {
            this.stacktrace.pop();
        }
        if (this.stacktrace.isEmpty() || this.stacktrace.peek() != -3) {
            this.stacktrace.push(-3);
        }
    }

    public MutableManaPool tryOverridePool(MutableManaPool pool) {
        return this.poolOverride.orElse(pool);
    }

    public List<Fragment> getArguments() {
        return this.arguments;
    }

    public int getRecursions() {
        return this.recursions;
    }

    public boolean isDelayed() {
        return this.delay > 0;
    }

    public void addDelay(int ticks) {
        this.delay += ticks;
    }

    public void decrementDelay() {
        --this.delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void pushStackTrace(int i) {
        this.stacktrace.push(i);
    }

    public void popStackTrace() {
        this.stacktrace.pop();
    }

    public class_2561 formatStackTrace() {
        class_2561 result = null;
        for (Integer i : this.stacktrace.reversed()) {
            result = result == null ? class_2561.method_43470((String)"") : result.method_27693(":");
            result = result.method_27693((String)(switch (i) {
                case -1 -> ">";
                case -2 -> "#";
                case -3 -> "&";
                default -> "" + i;
            }));
        }
        return result == null ? class_2561.method_30163((String)"") : result;
    }

    public Deque<Integer> getStacktrace() {
        return this.stacktrace;
    }

    public int getInitialStacktraceSize() {
        return this.initialStacktraceSize;
    }

    public boolean hasUsedMana() {
        return this.hasUsedMana;
    }

    public void useMana(Trick<?> trickSource, SpellContext ctx, float amount) throws NotEnoughManaBlunder {
        this.hasUsedMana = true;
        if (ctx.getManaPool().use(amount, (class_1937)ctx.source().getWorld()) > 0.0f) {
            throw new NotEnoughManaBlunder(trickSource, amount);
        }
    }
}

