/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.execution.executor;

import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellExecutor;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.execution.ExecutionState;
import dev.enjarai.trickster.spell.execution.TickData;
import dev.enjarai.trickster.spell.execution.executor.DefaultSpellExecutor;
import dev.enjarai.trickster.spell.execution.executor.SpellExecutorType;
import dev.enjarai.trickster.spell.execution.source.SpellSource;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.List;
import java.util.Optional;
import java.util.Stack;

public class FoldingSpellExecutor
implements SpellExecutor {
    public static final StructEndec<FoldingSpellExecutor> ENDEC = StructEndecBuilder.of((StructField)ExecutionState.ENDEC.fieldOf("state", e -> e.state), (StructField)SpellPart.ENDEC.fieldOf("executable", e -> e.executable), (StructField)Fragment.ENDEC.fieldOf("last_result", e -> e.lastResult), (StructField)EndecTomfoolery.stackOf(Fragment.ENDEC).fieldOf("values", e -> e.values), (StructField)EndecTomfoolery.stackOf(Fragment.ENDEC).fieldOf("keys", e -> e.keys), (StructField)Fragment.ENDEC.fieldOf("previous", e -> e.previous), (StructField)EndecTomfoolery.forcedSafeOptionalOf(SpellExecutor.INTERNAL_ENDEC).fieldOf("child", e -> e.child), FoldingSpellExecutor::new);
    private final ExecutionState state;
    private final SpellPart executable;
    private final Stack<Fragment> values;
    private final Stack<Fragment> keys;
    private final Fragment previous;
    private Optional<SpellExecutor> child;
    private int lastRunExecutions;
    private Fragment lastResult;

    private FoldingSpellExecutor(ExecutionState state, SpellPart executable, Fragment lastResult, Stack<Fragment> values, Stack<Fragment> keys, Fragment previous, Optional<SpellExecutor> child) {
        this.state = state;
        this.executable = executable;
        this.lastResult = lastResult;
        this.values = values;
        this.keys = keys;
        this.previous = previous;
        this.child = child;
    }

    public FoldingSpellExecutor(SpellContext ctx, SpellPart executable, Fragment result, Stack<Fragment> values, Stack<Fragment> keys, Fragment previous) {
        this(ctx.state().recurseOrThrow(List.of()), executable, result, values, keys, previous, Optional.empty());
        if (values.size() != keys.size()) {
            throw new IllegalStateException("FoldingSpellExecutor requires that the `values` and `keys` stack be of equal length!");
        }
    }

    @Override
    public SpellExecutorType<?> type() {
        return SpellExecutorType.FOLDING;
    }

    @Override
    public SpellPart spell() {
        return this.executable;
    }

    @Override
    public Optional<Fragment> run(SpellSource source, TickData data) throws BlunderException {
        return this.run(new SpellContext(this.state, source, data));
    }

    @Override
    public Optional<Fragment> run(SpellContext ctx) throws BlunderException {
        Optional<Fragment> result;
        this.lastRunExecutions = 0;
        if (this.child.isPresent() && (result = this.runChild(ctx)).isEmpty()) {
            return result;
        }
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            if (ctx.data().isExecutionLimitReached()) {
                return Optional.empty();
            }
            this.child = Optional.of(new DefaultSpellExecutor(this.executable, this.state.recurseOrThrow(List.of(this.lastResult, this.values.pop(), this.keys.pop(), this.previous))));
            Optional<Fragment> result2 = this.runChild(ctx);
            if (result2.isEmpty()) {
                return result2;
            }
            ctx.data().incrementExecutions();
            this.lastRunExecutions = ctx.data().getExecutions();
        }
        return Optional.of(this.lastResult);
    }

    private Optional<Fragment> runChild(SpellContext ctx) {
        Optional<Fragment> result = this.child.flatMap(c -> c.run(ctx.source(), ctx.data()));
        if (result.isPresent()) {
            this.lastResult = result.get();
            this.child = Optional.empty();
        }
        return result;
    }

    @Override
    public int getLastRunExecutions() {
        return this.child.map(SpellExecutor::getLastRunExecutions).orElse(this.lastRunExecutions);
    }

    @Override
    public ExecutionState getDeepestState() {
        return this.child.map(SpellExecutor::getDeepestState).orElse(this.state);
    }
}

