/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.execution.source;

import dev.enjarai.trickster.spell.CrowMind;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.execution.SpellExecutionManager;
import dev.enjarai.trickster.spell.execution.source.SpellSource;
import dev.enjarai.trickster.spell.mana.CachedInventoryManaPool;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import dev.enjarai.trickster.spell.mana.generation.InventoryBlockManaHandler;
import dev.enjarai.trickster.spell.mana.generation.ManaHandler;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.joml.Vector3d;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentKey;

public class BlockSpellSource<T extends class_2586 & CrowMind>
implements SpellSource {
    public final class_3218 world;
    public final class_2338 pos;
    public final T blockEntity;
    public final CachedInventoryManaPool pool;

    public BlockSpellSource(class_3218 world, class_2338 pos, T blockEntity) {
        this.world = world;
        this.pos = pos;
        this.blockEntity = blockEntity;
        this.pool = new CachedInventoryManaPool((class_1263)blockEntity);
    }

    public <C extends Component> Optional<C> getComponent(ComponentKey<C> key) {
        return key.maybeGet(this.blockEntity);
    }

    @Override
    public float getHealth() {
        return -1.0f;
    }

    @Override
    public float getMaxHealth() {
        return -1.0f;
    }

    @Override
    public MutableManaPool getManaPool() {
        return this.pool;
    }

    @Override
    public Vector3d getPos() {
        class_243 pos = this.pos.method_46558();
        return new Vector3d(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    @Override
    public class_2338 getBlockPos() {
        return this.pos;
    }

    @Override
    public Optional<Vector3d> getFacing() {
        return this.blockEntity.method_11010().method_28500((class_2769)class_2741.field_12525).map(class_2350::method_23955).map(v -> v.get(new Vector3d()));
    }

    @Override
    public class_3218 getWorld() {
        return this.world;
    }

    @Override
    public Optional<class_1263> getInventory() {
        return Optional.of((class_1263)this.blockEntity);
    }

    @Override
    public Fragment getCrowMind() {
        return ((CrowMind)this.blockEntity).getCrowMind();
    }

    @Override
    public void setCrowMind(Fragment fragment) {
        ((CrowMind)this.blockEntity).setCrowMind(fragment);
    }

    @Override
    public Optional<SpellExecutionManager> getExecutionManager() {
        T t = this.blockEntity;
        if (t instanceof SpellExecutionManager) {
            SpellExecutionManager manager = (SpellExecutionManager)t;
            return Optional.of(manager);
        }
        return Optional.empty();
    }

    @Override
    public ManaHandler getManaHandler() {
        return new InventoryBlockManaHandler(this.pos);
    }

    @Override
    public void offerOrDropItem(class_1799 stack) {
        Vector3d pos = this.getPos();
        this.world.method_8649((class_1297)new class_1542((class_1937)this.world, pos.x, pos.y, pos.z, stack));
    }
}

