/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.execution.source;

import dev.enjarai.trickster.ModAttachments;
import dev.enjarai.trickster.cca.CasterComponent;
import dev.enjarai.trickster.cca.ModEntityComponents;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.spell.CrowMindAttachment;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.execution.SpellExecutionManager;
import dev.enjarai.trickster.spell.execution.source.SpellSource;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.mana.CachedInventoryManaPool;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import dev.enjarai.trickster.spell.mana.PlayerManaPool;
import dev.enjarai.trickster.spell.mana.generation.ManaHandler;
import dev.enjarai.trickster.spell.mana.generation.PlayerManaHandler;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9334;
import org.joml.Vector3d;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentKey;

public class PlayerSpellSource
implements SpellSource {
    private final class_3222 player;
    private final SpellExecutionManager executionManager;
    private final CachedInventoryManaPool pool;
    private final class_1304 slot = class_1304.field_6173;

    public PlayerSpellSource(class_3222 player) {
        this(player, ((CasterComponent)ModEntityComponents.CASTER.get((Object)player)).getExecutionManager());
    }

    public PlayerSpellSource(class_3222 player, SpellExecutionManager executionManager) {
        this.player = player;
        this.executionManager = executionManager;
        this.pool = new PlayerManaPool(player);
    }

    @Override
    public Optional<class_3222> getPlayer() {
        return Optional.of(this.player);
    }

    @Override
    public Optional<class_1297> getCaster() {
        return Optional.of(this.player);
    }

    @Override
    public Optional<class_1263> getInventory() {
        return Optional.of(this.player.method_31548());
    }

    @Override
    public Optional<class_1799> getOtherHandStack(Predicate<class_1799> filter) {
        if (this.slot == class_1304.field_6173) {
            return Optional.ofNullable(this.player.method_6079()).filter(filter);
        }
        if (this.slot == class_1304.field_6171) {
            return Optional.ofNullable(this.player.method_6047()).filter(filter);
        }
        return Optional.ofNullable(this.player.method_6047()).filter(filter).or(() -> Optional.ofNullable(this.player.method_6079()).filter(filter));
    }

    @Override
    public Optional<SlotFragment> getOtherHandSlot() {
        if (this.slot == class_1304.field_6173) {
            return Optional.of(new SlotFragment(40, Optional.empty()));
        }
        if (this.slot == class_1304.field_6171) {
            return Optional.of(new SlotFragment(this.player.method_31548().field_7545, Optional.empty()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<SpellExecutionManager> getExecutionManager() {
        return Optional.of(this.executionManager);
    }

    @Override
    public <T extends Component> Optional<T> getComponent(ComponentKey<T> key) {
        return key.maybeGet((Object)this.player);
    }

    @Override
    public float getHealth() {
        return this.player.method_6032();
    }

    @Override
    public float getMaxHealth() {
        return this.player.method_6063();
    }

    @Override
    public MutableManaPool getManaPool() {
        return this.pool;
    }

    public static boolean isSpellStack(class_1799 stack) {
        return stack.method_57826(ModComponents.FRAGMENT) || stack.method_57826(class_9334.field_49622) && stack.method_57826(ModComponents.SELECTED_SLOT);
    }

    @Override
    public Vector3d getPos() {
        return new Vector3d(this.player.method_23317(), this.player.method_23318(), this.player.method_23321());
    }

    @Override
    public class_2338 getBlockPos() {
        return this.player.method_24515();
    }

    @Override
    public Optional<Vector3d> getFacing() {
        return Optional.of(this.player.method_5720().toVector3d());
    }

    @Override
    public class_3218 getWorld() {
        return this.player.method_51469();
    }

    @Override
    public Fragment getCrowMind() {
        CrowMindAttachment crow = (CrowMindAttachment)this.player.getAttached(ModAttachments.CROW_MIND);
        if (crow == null) {
            return VoidFragment.INSTANCE;
        }
        return crow.fragment();
    }

    @Override
    public void setCrowMind(Fragment fragment) {
        this.player.setAttached(ModAttachments.CROW_MIND, (Object)new CrowMindAttachment(fragment));
    }

    @Override
    public ManaHandler getManaHandler() {
        return new PlayerManaHandler(this.player);
    }

    @Override
    public void offerOrDropItem(class_1799 stack) {
        this.player.method_31548().method_7398(stack);
    }
}

