/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.fragment;

import com.mojang.serialization.Lifecycle;
import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.Trickster;
import dev.enjarai.trickster.spell.EvaluationResult;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.PatternGlyph;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.fragment.BlockTypeFragment;
import dev.enjarai.trickster.spell.fragment.BooleanFragment;
import dev.enjarai.trickster.spell.fragment.DimensionFragment;
import dev.enjarai.trickster.spell.fragment.EntityFragment;
import dev.enjarai.trickster.spell.fragment.EntityTypeFragment;
import dev.enjarai.trickster.spell.fragment.ItemTypeFragment;
import dev.enjarai.trickster.spell.fragment.ListFragment;
import dev.enjarai.trickster.spell.fragment.MapFragment;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.SlotFragment;
import dev.enjarai.trickster.spell.fragment.StringFragment;
import dev.enjarai.trickster.spell.fragment.TypeFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.fragment.ZalgoFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.type.ArgType;
import dev.enjarai.trickster.spell.type.RetType;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9248;

public class FragmentType<T extends Fragment>
implements RetType<T>,
ArgType<T> {
    public static final class_5321<class_2378<FragmentType<?>>> REGISTRY_KEY = class_5321.method_29180((class_2960)Trickster.id("fragment_type"));
    public static final Int2ObjectMap<class_2960> INT_ID_FALLBACK = new Int2ObjectOpenHashMap<class_2960>(){
        {
            this.put(-777274987, Trickster.id("entity_type"));
            this.put(-2055452291, Trickster.id("slot"));
            this.put(719778857, Trickster.id("spell_part"));
            this.put(1201617608, Trickster.id("number"));
            this.put(1343995792, Trickster.id("string"));
            this.put(94838885, Trickster.id("item_type"));
            this.put(-839744897, Trickster.id("pattern_literal"));
            this.put(937706338, Trickster.id("entity"));
            this.put(-2055409991, Trickster.id("type"));
            this.put(-1943319220, Trickster.id("zalgo"));
            this.put(1415594178, Trickster.id("vector"));
            this.put(-772426965, Trickster.id("block_type"));
            this.put(-2058877733, Trickster.id("map"));
            this.put(1444891407, Trickster.id("pattern"));
            this.put(1140968677, Trickster.id("dimension"));
            this.put(-2055360237, Trickster.id("void"));
            this.put(-2055663587, Trickster.id("list"));
            this.put(-1994273881, Trickster.id("boolean"));
        }
    };
    public static final Int2ObjectMap<class_2960> INT_ID_LOOKUP = new Int2ObjectOpenHashMap();
    public static final Endec<FragmentType<?>> INT_ID_ENDEC = Endec.INT.xmap(FragmentType::getFromInt, FragmentType::getIntId);
    public static final class_2378<FragmentType<?>> REGISTRY = FabricRegistryBuilder.from((class_2385)new class_2370<FragmentType<?>>(REGISTRY_KEY, Lifecycle.stable()){

        public class_6880.class_6883<FragmentType<?>> add(class_5321<FragmentType<?>> key, FragmentType<?> value, class_9248 info) {
            int hash = key.method_29177().hashCode();
            if (INT_ID_LOOKUP.containsKey(hash)) {
                Trickster.LOGGER.error("WARNING: Hashcode collision between two fragment types, spell imports and exports may not work as expected. ({} overrode {})", (Object)key.method_29177(), INT_ID_LOOKUP.get(hash));
                throw new IllegalStateException("WARNING: Hashcode collision between two fragment types");
            }
            INT_ID_LOOKUP.put(hash, (Object)key.method_29177());
            return super.method_10272(key, value, info);
        }
    }).buildAndRegister();
    public static final FragmentType<TypeFragment> TYPE = FragmentType.register("type", TypeFragment.ENDEC, 0x66CC00);
    public static final FragmentType<NumberFragment> NUMBER = FragmentType.register("number", NumberFragment.ENDEC, 0xDDAA00);
    public static final FragmentType<VectorFragment> VECTOR = FragmentType.register("vector", VectorFragment.ENDEC, 0xAA7711);
    public static final FragmentType<ListFragment> LIST = FragmentType.register("list", ListFragment.ENDEC);
    public static final FragmentType<VoidFragment> VOID = FragmentType.register("void", VoidFragment.ENDEC, 0x4400AA);
    public static final FragmentType<PatternGlyph> PATTERN = FragmentType.register("pattern", PatternGlyph.ENDEC, 0x6644AA);
    public static final FragmentType<Pattern> PATTERN_LITERAL = FragmentType.register("pattern_literal", EndecTomfoolery.funnyFieldOf(Pattern.ENDEC, "pattern"), 0xBBBBAA);
    public static final FragmentType<SpellPart> SPELL_PART = FragmentType.register("spell_part", SpellPart.ENDEC, 0xAA44AA);
    public static final FragmentType<EntityFragment> ENTITY = FragmentType.register("entity", EntityFragment.ENDEC, 0x338888);
    public static final FragmentType<ZalgoFragment> ZALGO = FragmentType.register("zalgo", ZalgoFragment.ENDEC, 0x444444);
    public static final FragmentType<ItemTypeFragment> ITEM_TYPE = FragmentType.register("item_type", ItemTypeFragment.ENDEC, 0x2266AA);
    public static final FragmentType<SlotFragment> SLOT = FragmentType.register("slot", SlotFragment.ENDEC, 0x77AAEE);
    public static final FragmentType<BlockTypeFragment> BLOCK_TYPE = FragmentType.register("block_type", BlockTypeFragment.ENDEC, 0x44AA33);
    public static final FragmentType<EntityTypeFragment> ENTITY_TYPE = FragmentType.register("entity_type", EntityTypeFragment.ENDEC, 0x8877BB);
    public static final FragmentType<DimensionFragment> DIMENSION = FragmentType.register("dimension", DimensionFragment.ENDEC, 0xDD55BB);
    public static final FragmentType<StringFragment> STRING = FragmentType.register("string", StringFragment.ENDEC, 0xAABB77);
    public static final FragmentType<MapFragment> MAP = FragmentType.register("map", MapFragment.ENDEC);
    public static final FragmentType<BooleanFragment> BOOLEAN = (FragmentType)class_2378.method_10230(REGISTRY, (class_2960)Trickster.id("boolean"), (Object)new FragmentType<BooleanFragment>(BooleanFragment.ENDEC, OptionalInt.of(0xAA3355)){

        @Override
        public BooleanFragment compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
            return BooleanFragment.of(fragments.getFirst().asBoolean());
        }

        @Override
        public boolean match(List<Fragment> fragments) {
            return true;
        }
    });
    private final StructEndec<T> endec;
    private final OptionalInt color;

    public FragmentType(StructEndec<T> endec, OptionalInt color) {
        this.endec = endec;
        this.color = color;
    }

    private static <T extends Fragment> FragmentType<T> register(String name, StructEndec<T> codec, int color) {
        return (FragmentType)class_2378.method_10230(REGISTRY, (class_2960)Trickster.id(name), new FragmentType<T>(codec, OptionalInt.of(color)));
    }

    private static <T extends Fragment> FragmentType<T> register(String name, StructEndec<T> codec) {
        return (FragmentType)class_2378.method_10230(REGISTRY, (class_2960)Trickster.id(name), new FragmentType<T>(codec, OptionalInt.of(0xAAAAAA)));
    }

    public static void register() {
    }

    public class_5250 getName() {
        class_2960 id = REGISTRY.method_10221((Object)this);
        if (id == null) {
            return class_2561.method_43470((String)"Unregistered");
        }
        class_5250 text = class_2561.method_43471((String)("trickster.fragment." + id.method_12836() + "." + id.method_12832()));
        if (this.color.isPresent()) {
            text = text.method_54663(this.color.getAsInt());
        }
        return text;
    }

    @Override
    public class_5250 asText() {
        return this.getName();
    }

    @Override
    public EvaluationResult into(T result) {
        return result;
    }

    public static FragmentType<?> getFromInt(int intId) {
        class_2960 id = (class_2960)INT_ID_LOOKUP.get(intId);
        if (id == null && (id = (class_2960)INT_ID_FALLBACK.get(intId)) == null) {
            throw new IllegalArgumentException("Not a valid int id for fragment type: " + intId);
        }
        return (FragmentType)REGISTRY.method_10223(id);
    }

    public int getIntId() {
        return REGISTRY.method_10221((Object)this).hashCode();
    }

    @Override
    public int argc(List<Fragment> fragments) {
        return 1;
    }

    @Override
    public T compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
        return (T)fragments.getFirst();
    }

    @Override
    public boolean match(List<Fragment> fragments) {
        return fragments.getFirst().type() == this;
    }

    @Override
    public ArgType<T> wardOf() {
        return new ArgType<T>(){

            @Override
            public int argc(List<Fragment> fragments) {
                return FragmentType.this.argc(fragments);
            }

            @Override
            public T compose(Trick<?> trick, SpellContext ctx, List<Fragment> fragments) {
                Object result = FragmentType.this.compose((Trick)trick, ctx, (List)fragments);
                if (result instanceof EntityFragment) {
                    EntityFragment entity = (EntityFragment)result;
                    ArgType.tryWard(trick, ctx, entity, fragments);
                }
                return result;
            }

            @Override
            public boolean match(List<Fragment> fragments) {
                return FragmentType.this.match(fragments);
            }

            @Override
            public ArgType<T> wardOf() {
                return this;
            }

            @Override
            public class_5250 asText() {
                return FragmentType.this.asText();
            }
        };
    }

    public StructEndec<T> endec() {
        return this.endec;
    }

    public OptionalInt color() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FragmentType that = (FragmentType)obj;
        return Objects.equals(this.endec, that.endec) && Objects.equals(this.color, that.color);
    }

    public int hashCode() {
        return Objects.hash(this.endec, this.color);
    }

    public String toString() {
        return "FragmentType[endec=" + String.valueOf(this.endec) + ", color=" + String.valueOf(this.color) + "]";
    }
}

