/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.fragment;

import com.google.common.collect.ImmutableList;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.SpellContext;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.execution.executor.FoldingSpellExecutor;
import dev.enjarai.trickster.spell.fragment.FoldableFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.util.FuzzyUtils;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public record ListFragment(List<Fragment> fragments) implements FoldableFragment
{
    public static final StructEndec<ListFragment> ENDEC = StructEndecBuilder.of((StructField)Fragment.ENDEC.listOf().fieldOf("fragments", ListFragment::fragments), ListFragment::new);
    public static final ListFragment EMPTY = new ListFragment((List<Fragment>)ImmutableList.of());

    @Override
    public FragmentType<?> type() {
        return FragmentType.LIST;
    }

    @Override
    public class_2561 asText() {
        class_5250 result = class_2561.method_43470((String)"[");
        for (int i = 0; i < this.fragments().size(); ++i) {
            Fragment frag = this.fragments().get(i);
            if (i != 0) {
                result = result.method_27693(", ");
            }
            result = result.method_10852(frag.asFormattedText());
        }
        return result.method_27693("]");
    }

    @Override
    public Fragment applyEphemeral() {
        return new ListFragment(this.fragments.stream().map(Fragment::applyEphemeral).toList());
    }

    @Override
    public int getWeight() {
        int weight = 16;
        for (Fragment fragment : this.fragments) {
            weight += fragment.getWeight();
        }
        return weight;
    }

    @Override
    public boolean fuzzyEquals(Fragment other) {
        if (other instanceof ListFragment) {
            ListFragment that = (ListFragment)other;
            return FuzzyUtils.fuzzyEquals(this.fragments, that.fragments);
        }
        return false;
    }

    @Override
    public int fuzzyHash() {
        return FuzzyUtils.fuzzyHash(this.fragments);
    }

    @Override
    public FoldingSpellExecutor fold(SpellContext ctx, SpellPart executable, Fragment identity) {
        Stack<Fragment> keys = new Stack<Fragment>();
        Stack<Fragment> values = new Stack<Fragment>();
        for (int i = this.fragments.size() - 1; i >= 0; --i) {
            keys.push(new NumberFragment(i));
        }
        values.addAll(this.fragments.reversed());
        return new FoldingSpellExecutor(ctx, executable, identity, values, keys, this);
    }

    public ListFragment addRange(ListFragment other) throws BlunderException {
        return new ListFragment((List<Fragment>)ImmutableList.builder().addAll(this.fragments).addAll(other.fragments).build());
    }
}

