/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.fragment;

import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.DivideByZeroBlunder;
import dev.enjarai.trickster.spell.blunder.IncompatibleTypesBlunder;
import dev.enjarai.trickster.spell.blunder.NaNBlunder;
import dev.enjarai.trickster.spell.fragment.AddableFragment;
import dev.enjarai.trickster.spell.fragment.DivisibleFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.MultiplicableFragment;
import dev.enjarai.trickster.spell.fragment.RoundableFragment;
import dev.enjarai.trickster.spell.fragment.SubtractableFragment;
import dev.enjarai.trickster.spell.fragment.VectorFragment;
import dev.enjarai.trickster.spell.trick.Tricks;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.Objects;
import net.minecraft.class_2561;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public final class NumberFragment
implements AddableFragment,
SubtractableFragment,
MultiplicableFragment,
DivisibleFragment,
RoundableFragment {
    public static final StructEndec<NumberFragment> ENDEC = StructEndecBuilder.of((StructField)Endec.DOUBLE.fieldOf("number", NumberFragment::number), NumberFragment::new);
    private final double number;

    public NumberFragment(double number) throws BlunderException {
        if (Double.isNaN(number)) {
            throw new NaNBlunder();
        }
        this.number = number;
    }

    @Override
    public FragmentType<?> type() {
        return FragmentType.NUMBER;
    }

    @Override
    public class_2561 asText() {
        return class_2561.method_43470((String)String.format("%.2f", this.number));
    }

    @Override
    public int getWeight() {
        return 8;
    }

    @Override
    public AddableFragment add(Fragment other) throws BlunderException {
        if (other instanceof NumberFragment) {
            NumberFragment num = (NumberFragment)other;
            return new NumberFragment(this.number + num.number);
        }
        if (other instanceof VectorFragment) {
            VectorFragment vec = (VectorFragment)other;
            Vector3dc vector = vec.vector();
            return new VectorFragment((Vector3dc)new Vector3d(this.number + vector.x(), this.number + vector.y(), this.number + vector.z()));
        }
        throw new IncompatibleTypesBlunder(Tricks.ADD);
    }

    @Override
    public SubtractableFragment subtract(Fragment other) throws BlunderException {
        if (other instanceof NumberFragment) {
            NumberFragment num = (NumberFragment)other;
            return new NumberFragment(this.number - num.number);
        }
        if (other instanceof VectorFragment) {
            VectorFragment vec = (VectorFragment)other;
            Vector3dc vector = vec.vector();
            return new VectorFragment((Vector3dc)new Vector3d(this.number - vector.x(), this.number - vector.y(), this.number - vector.z()));
        }
        throw new IncompatibleTypesBlunder(Tricks.SUBTRACT);
    }

    @Override
    public MultiplicableFragment multiply(Fragment other) throws BlunderException {
        if (other instanceof NumberFragment) {
            NumberFragment num = (NumberFragment)other;
            return new NumberFragment(this.number * num.number);
        }
        if (other instanceof VectorFragment) {
            VectorFragment vec = (VectorFragment)other;
            Vector3dc vector = vec.vector();
            return new VectorFragment((Vector3dc)new Vector3d(this.number * vector.x(), this.number * vector.y(), this.number * vector.z()));
        }
        throw new IncompatibleTypesBlunder(Tricks.MULTIPLY);
    }

    @Override
    public DivisibleFragment divide(Fragment other) throws BlunderException {
        if (other instanceof NumberFragment) {
            NumberFragment num = (NumberFragment)other;
            if (num.number == 0.0) {
                throw new DivideByZeroBlunder(Tricks.DIVIDE);
            }
            return new NumberFragment(this.number / num.number);
        }
        if (other instanceof VectorFragment) {
            VectorFragment vec = (VectorFragment)other;
            Vector3dc vector = vec.vector();
            if (vector.x() * vector.y() * vector.z() == 0.0) {
                throw new DivideByZeroBlunder(Tricks.DIVIDE);
            }
            return new VectorFragment((Vector3dc)new Vector3d(this.number / vector.x(), this.number / vector.y(), this.number / vector.z()));
        }
        throw new IncompatibleTypesBlunder(Tricks.DIVIDE);
    }

    @Override
    public RoundableFragment floor() throws BlunderException {
        return new NumberFragment(Math.floor(this.number));
    }

    @Override
    public RoundableFragment ceil() throws BlunderException {
        return new NumberFragment(Math.ceil(this.number));
    }

    @Override
    public RoundableFragment round() throws BlunderException {
        return new NumberFragment(Math.round(this.number));
    }

    @Override
    public boolean fuzzyEquals(Fragment other) {
        if (other instanceof NumberFragment) {
            NumberFragment n = (NumberFragment)other;
            double precision = 0.0625;
            return n.number > this.number - precision && n.number < this.number + precision;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof NumberFragment)) return false;
        NumberFragment n = (NumberFragment)obj;
        if (n.number != this.number) return false;
        return true;
    }

    public boolean isInteger() {
        return this.number - Math.floor(this.number) == 0.0;
    }

    public int asInt() {
        return (int)Math.floor(this.number);
    }

    public double number() {
        return this.number;
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }

    public String toString() {
        return "NumberFragment[number=" + this.number + "]";
    }
}

