/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.fragment;

import dev.enjarai.trickster.EndecTomfoolery;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.blunder.BlunderException;
import dev.enjarai.trickster.spell.blunder.DivideByZeroBlunder;
import dev.enjarai.trickster.spell.blunder.IncompatibleTypesBlunder;
import dev.enjarai.trickster.spell.blunder.NaNBlunder;
import dev.enjarai.trickster.spell.fragment.AddableFragment;
import dev.enjarai.trickster.spell.fragment.DivisibleFragment;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.MultiplicableFragment;
import dev.enjarai.trickster.spell.fragment.NumberFragment;
import dev.enjarai.trickster.spell.fragment.RoundableFragment;
import dev.enjarai.trickster.spell.fragment.SubtractableFragment;
import dev.enjarai.trickster.spell.trick.Tricks;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class VectorFragment
implements AddableFragment,
SubtractableFragment,
MultiplicableFragment,
DivisibleFragment,
RoundableFragment {
    public static final StructEndec<VectorFragment> ENDEC = StructEndecBuilder.of((StructField)EndecTomfoolery.vectorEndec(Endec.DOUBLE, Vector3d::new, Vector3dc::x, Vector3dc::y, Vector3dc::z).fieldOf("vector", VectorFragment::vector), VectorFragment::new);
    public static final VectorFragment ZERO = new VectorFragment((Vector3dc)new Vector3d());
    private final Vector3dc vector;

    public VectorFragment(Vector3dc vector) throws BlunderException {
        if (Double.isNaN(vector.x()) || Double.isNaN(vector.y()) || Double.isNaN(vector.z())) {
            throw new NaNBlunder();
        }
        this.vector = vector;
    }

    public Vector3dc vector() {
        return this.vector;
    }

    public double x() {
        return this.vector.x();
    }

    public double y() {
        return this.vector.y();
    }

    public double z() {
        return this.vector.z();
    }

    @Override
    public FragmentType<?> type() {
        return FragmentType.VECTOR;
    }

    @Override
    public class_2561 asText() {
        return class_2561.method_43470((String)"(").method_10852(new NumberFragment(this.vector.x()).asFormattedText()).method_27693(", ").method_10852(new NumberFragment(this.vector.y()).asFormattedText()).method_27693(", ").method_10852(new NumberFragment(this.vector.z()).asFormattedText()).method_27693(")");
    }

    @Override
    public int getWeight() {
        return 24;
    }

    @Override
    public AddableFragment add(Fragment other) throws BlunderException {
        if (other instanceof VectorFragment) {
            VectorFragment vec = (VectorFragment)other;
            return new VectorFragment((Vector3dc)this.vector.add(vec.vector, new Vector3d()));
        }
        if (other instanceof NumberFragment) {
            NumberFragment num = (NumberFragment)other;
            return new VectorFragment((Vector3dc)new Vector3d(this.vector.x() + num.number(), this.vector.y() + num.number(), this.vector.z() + num.number()));
        }
        throw new IncompatibleTypesBlunder(Tricks.ADD);
    }

    @Override
    public SubtractableFragment subtract(Fragment other) throws BlunderException {
        if (other instanceof VectorFragment) {
            VectorFragment vec = (VectorFragment)other;
            return new VectorFragment((Vector3dc)this.vector.sub(vec.vector, new Vector3d()));
        }
        if (other instanceof NumberFragment) {
            NumberFragment num = (NumberFragment)other;
            return new VectorFragment((Vector3dc)new Vector3d(this.vector.x() - num.number(), this.vector.y() - num.number(), this.vector.z() - num.number()));
        }
        throw new IncompatibleTypesBlunder(Tricks.SUBTRACT);
    }

    @Override
    public MultiplicableFragment multiply(Fragment other) throws BlunderException {
        if (other instanceof VectorFragment) {
            VectorFragment vec = (VectorFragment)other;
            return new VectorFragment((Vector3dc)this.vector.mul(vec.vector, new Vector3d()));
        }
        if (other instanceof NumberFragment) {
            NumberFragment num = (NumberFragment)other;
            return new VectorFragment((Vector3dc)this.vector.mul(num.number(), new Vector3d()));
        }
        throw new IncompatibleTypesBlunder(Tricks.MULTIPLY);
    }

    @Override
    public DivisibleFragment divide(Fragment other) throws BlunderException {
        if (other instanceof VectorFragment) {
            VectorFragment vec = (VectorFragment)other;
            if (vec.vector.x() * vec.vector.y() * vec.vector.z() == 0.0) {
                throw new DivideByZeroBlunder(Tricks.DIVIDE);
            }
            return new VectorFragment((Vector3dc)this.vector.div(vec.vector, new Vector3d()));
        }
        if (other instanceof NumberFragment) {
            NumberFragment num = (NumberFragment)other;
            if (num.number() == 0.0) {
                throw new DivideByZeroBlunder(Tricks.DIVIDE);
            }
            return new VectorFragment((Vector3dc)this.vector.div(num.number(), new Vector3d()));
        }
        throw new IncompatibleTypesBlunder(Tricks.DIVIDE);
    }

    @Override
    public RoundableFragment floor() throws BlunderException {
        return new VectorFragment((Vector3dc)this.vector.floor(new Vector3d()));
    }

    @Override
    public RoundableFragment ceil() throws BlunderException {
        return new VectorFragment((Vector3dc)this.vector.ceil(new Vector3d()));
    }

    @Override
    public RoundableFragment round() throws BlunderException {
        return new VectorFragment((Vector3dc)this.vector.round(new Vector3d()));
    }

    @Override
    public boolean fuzzyEquals(Fragment other) {
        if (other instanceof VectorFragment) {
            VectorFragment v = (VectorFragment)other;
            return v.vector.equals(this.vector, 0.0625);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof VectorFragment)) return false;
        VectorFragment v = (VectorFragment)obj;
        if (!v.vector.equals((Object)this.vector)) return false;
        return true;
    }

    public static VectorFragment of(class_2338 pos) {
        class_243 dPos = pos.method_46558();
        return new VectorFragment((Vector3dc)new Vector3d(dPos.method_10216(), dPos.method_10214(), dPos.method_10215()));
    }

    public static VectorFragment of(class_243 pos) {
        return new VectorFragment((Vector3dc)new Vector3d(pos.method_10216(), pos.method_10214(), pos.method_10215()));
    }

    public static VectorFragment of(class_2382 pos) {
        return new VectorFragment((Vector3dc)new Vector3d((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
    }

    public class_2338 toBlockPos() {
        return class_2338.method_49637((double)this.vector.x(), (double)this.vector.y(), (double)this.vector.z());
    }

    public class_2350 toDirection() {
        return class_2350.method_10142((double)this.vector.x(), (double)this.vector.y(), (double)this.vector.z());
    }

    public int hashCode() {
        return Objects.hash(this.vector);
    }

    public String toString() {
        return "VectorFragment[vector=" + String.valueOf(this.vector) + "]";
    }
}

