/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.trickster.spell.mana;

import dev.enjarai.trickster.item.component.ManaComponent;
import dev.enjarai.trickster.item.component.ModComponents;
import dev.enjarai.trickster.spell.mana.ManaPool;
import dev.enjarai.trickster.spell.mana.ManaPoolType;
import dev.enjarai.trickster.spell.mana.MutableManaPool;
import dev.enjarai.trickster.spell.mana.SharedManaPool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public class CachedInventoryManaPool
implements MutableManaPool {
    private final class_1263 inventory;
    private final List<Integer> slots = new ArrayList<Integer>();

    public CachedInventoryManaPool(class_1263 inventory) {
        this.inventory = inventory;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (!inventory.method_5438(i).method_57826(ModComponents.MANA)) continue;
            this.slots.add(i);
        }
    }

    @Override
    @Nullable
    public ManaPoolType<?> type() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float get(class_1937 world) {
        float result = 0.0f;
        ArrayList<UUID> identifiedKnots = new ArrayList<UUID>();
        Iterator<Integer> iterator = this.slots.iterator();
        while (iterator.hasNext()) {
            Integer i = iterator.next();
            ManaComponent comp = (ManaComponent)this.inventory.method_5438(i.intValue()).method_57824(ModComponents.MANA);
            if (comp == null) continue;
            ManaPool manaPool = comp.pool();
            if (manaPool instanceof SharedManaPool) {
                SharedManaPool sharedManaPool = (SharedManaPool)manaPool;
                try {
                    UUID uUID;
                    UUID uuid = uUID = sharedManaPool.uuid();
                    if (identifiedKnots.contains(uuid)) continue;
                    identifiedKnots.add(uuid);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            result += comp.pool().get(world);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getMax(class_1937 world) {
        float result = 0.0f;
        ArrayList<UUID> identifiedKnots = new ArrayList<UUID>();
        Iterator<Integer> iterator = this.slots.iterator();
        while (iterator.hasNext()) {
            Integer i = iterator.next();
            ManaComponent comp = (ManaComponent)this.inventory.method_5438(i.intValue()).method_57824(ModComponents.MANA);
            if (comp == null) continue;
            ManaPool manaPool = comp.pool();
            if (manaPool instanceof SharedManaPool) {
                SharedManaPool sharedManaPool = (SharedManaPool)manaPool;
                try {
                    UUID uUID;
                    UUID uuid = uUID = sharedManaPool.uuid();
                    if (identifiedKnots.contains(uuid)) continue;
                    identifiedKnots.add(uuid);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            result += comp.pool().getMax(world);
        }
        return result;
    }

    @Override
    public void set(float value, class_1937 world) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMax(float value, class_1937 world) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float use(float amount, class_1937 world) {
        for (Integer i : this.slots) {
            class_1799 stack = this.inventory.method_5438(i.intValue());
            ManaComponent comp = (ManaComponent)stack.method_57824(ModComponents.MANA);
            if (comp == null) continue;
            MutableManaPool pool = comp.pool().makeClone(world);
            amount = pool.use(amount, world);
            stack.method_57379(ModComponents.MANA, (Object)comp.with(pool));
        }
        return amount;
    }

    @Override
    public float refill(float amount, class_1937 world) {
        for (Integer i : this.slots) {
            class_1799 stack = this.inventory.method_5438(i.intValue());
            ManaComponent comp = (ManaComponent)stack.method_57824(ModComponents.MANA);
            if (comp == null) continue;
            MutableManaPool pool = comp.pool().makeClone(world);
            amount = pool.refill(amount, world);
            stack.method_57379(ModComponents.MANA, (Object)comp.with(pool));
        }
        return amount;
    }

    @Override
    public MutableManaPool makeClone(class_1937 world) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

